package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.QCarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerPageInfoVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author Danny.Wang
 * @title CarOwnerInfoRepoProc
 * @Date2023/2/9 11:52
 */
@Repository
public class CarOwnerInfoRepoProc extends BaseRepoProc<CarOwnerInfoDO> {

    private static final QCarOwnerInfoDO Q_CAR_OWNER_INFO_DO = QCarOwnerInfoDO.carOwnerInfoDO;

    protected CarOwnerInfoRepoProc() {
        super(Q_CAR_OWNER_INFO_DO);
    }

    public CarOwnerPageInfoVO findPageInfo(Long carOwnerId){
        return jpaQueryFactory.select(Projections.bean(CarOwnerPageInfoVO.class
                ,Q_CAR_OWNER_INFO_DO.carOwnerId
                ,Q_CAR_OWNER_INFO_DO.userName
                ,Q_CAR_OWNER_INFO_DO.userPhone
                ,Q_CAR_OWNER_INFO_DO.fileCode,
                        Q_CAR_OWNER_INFO_DO.url))
                .from(Q_CAR_OWNER_INFO_DO)
                .where(Q_CAR_OWNER_INFO_DO.carOwnerId.eq(carOwnerId))
                .fetchOne();

    }

    public Long findByCasUserIdAndUserPhone(String phone, Long casUserId){
        return jpaQueryFactory.select(Q_CAR_OWNER_INFO_DO.carOwnerId)
                .from(Q_CAR_OWNER_INFO_DO)
                .where(Q_CAR_OWNER_INFO_DO.casUserId.eq(casUserId)
                        .and(Q_CAR_OWNER_INFO_DO.userPhone.eq(phone)))
                .fetchOne();
    }
    public Long findByUserPhone(String phone){
        return jpaQueryFactory.select(Q_CAR_OWNER_INFO_DO.carOwnerId)
                .from(Q_CAR_OWNER_INFO_DO)
                .where(Q_CAR_OWNER_INFO_DO.userPhone.eq(phone))
                .fetchOne();
    }
    public List<CarOwnerInfoDO> queryByUserPhone(String userPhone){
     return    jpaQueryFactory.select(Q_CAR_OWNER_INFO_DO)
                .from(Q_CAR_OWNER_INFO_DO)
                .where(Q_CAR_OWNER_INFO_DO.userPhone.eq(userPhone))
                .fetch();
    }

    public PagingVO<CarOwnerInfoMngRespVO> ownerInfoMngQuery(CarOwnerInfoMngParam param) {

        JPAQuery<CarOwnerInfoMngRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                CarOwnerInfoMngRespVO.class,
                Q_CAR_OWNER_INFO_DO.id,
                Q_CAR_OWNER_INFO_DO.carOwnerId,
                Q_CAR_OWNER_INFO_DO.casUserId,
                Q_CAR_OWNER_INFO_DO.fileCode,
                Q_CAR_OWNER_INFO_DO.url,
                Q_CAR_OWNER_INFO_DO.userName,
                Q_CAR_OWNER_INFO_DO.sex,
                Q_CAR_OWNER_INFO_DO.birthdayTime,
                Q_CAR_OWNER_INFO_DO.userPhone,
                Q_CAR_OWNER_INFO_DO.enabledFlag,
                Q_CAR_OWNER_INFO_DO.updater,
                Q_CAR_OWNER_INFO_DO.secUserId,
                Q_CAR_OWNER_INFO_DO.secBuId,
                Q_CAR_OWNER_INFO_DO.secOuId,
                Q_CAR_OWNER_INFO_DO.deleteFlag,
                Q_CAR_OWNER_INFO_DO.creator,
                Q_CAR_OWNER_INFO_DO.createTime,
                Q_CAR_OWNER_INFO_DO.createUserId,
                Q_CAR_OWNER_INFO_DO.remark
        )).from(Q_CAR_OWNER_INFO_DO);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereMngParam(param));
            param.fillOrders(jpaQuery, Q_CAR_OWNER_INFO_DO);
            param.setPaging(jpaQuery);
        }

        return PagingVO.<CarOwnerInfoMngRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }

    private Predicate whereMngParam(CarOwnerInfoMngParam param) {

        Predicate predicate = Q_CAR_OWNER_INFO_DO.isNotNull();
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty(param.getUserName())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.userName.like("%" + param.getUserName() + "%"));
        }
        if (!StringUtils.isEmpty(param.getUserPhone())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.userPhone.like("%" + param.getUserPhone() + "%"));
        }
        if (param.getSex() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.sex.eq(param.getSex()));
        }
        if (param.getCarOwnerId() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.carOwnerId.like("%" + param.getCarOwnerId() + "%"));
        }
        if(param.getStartTime() != null){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.createTime.goe(param.getStartTime()));
        }
        if(param.getEndTime() != null){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.createTime.loe(param.getEndTime()));
        }
        return predicate;
    }

    public void updateEnabledFlag(Long casUserId, int enabledFlag) {
        Predicate predicate = Q_CAR_OWNER_INFO_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_CAR_OWNER_INFO_DO)
                .set(Q_CAR_OWNER_INFO_DO.enabledFlag, enabledFlag)
                .where(ExpressionUtils.and(predicate, Q_CAR_OWNER_INFO_DO.casUserId.eq(casUserId)));
        jpaUpdateClause.execute();
    }
}
