package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.*;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderCancelParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @author RYH
 * @date 2023/2/14
 */
@Repository
public class ComplaintOrderRepoProc extends BaseRepoProc<ComplaintOrderDO> {
    private static final QComplaintOrderDO Q_COMPLAINT_ORDER_DO = QComplaintOrderDO.complaintOrderDO;
    private static final QOrderEvaluationDO Q_ORDER_EVALUATION_DO = QOrderEvaluationDO.orderEvaluationDO;
    private static final QRepairOrderDO Q_REPAIR_ORDER_DO = QRepairOrderDO.repairOrderDO;

    private static final QCarOwnerVehicleInfoDO Q_CAR_OWNER_VEHICLE_INFO_DO = QCarOwnerVehicleInfoDO.carOwnerVehicleInfoDO;

    protected ComplaintOrderRepoProc() {
        super(Q_COMPLAINT_ORDER_DO);
    }

    public PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param) {

        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.issueType,
                Q_COMPLAINT_ORDER_DO.issueDescription,
                Q_COMPLAINT_ORDER_DO.carOwnerId,
                Q_COMPLAINT_ORDER_DO.orderNo,
                Q_COMPLAINT_ORDER_DO.orderPerson,
                Q_COMPLAINT_ORDER_DO.orderTel,
                Q_COMPLAINT_ORDER_DO.vehicleNo,
                Q_COMPLAINT_ORDER_DO.vehicleType,
                Q_COMPLAINT_ORDER_DO.orderType,
                Q_COMPLAINT_ORDER_DO.orderStatus,
                Q_COMPLAINT_ORDER_DO.handlePersonName,
                Q_COMPLAINT_ORDER_DO.handlePersonTel,
                Q_COMPLAINT_ORDER_DO.handleReply,
                Q_COMPLAINT_ORDER_DO.baseNo,
                Q_COMPLAINT_ORDER_DO.confirmType,
                Q_COMPLAINT_ORDER_DO.issueSupplement,
                Q_COMPLAINT_ORDER_DO.subdivisionType,
                Q_COMPLAINT_ORDER_DO.dispatchPersonId,
                Q_COMPLAINT_ORDER_DO.timeoutStatus,
                Q_COMPLAINT_ORDER_DO.dispatchTime,
                Q_COMPLAINT_ORDER_DO.completeTime,
                Q_COMPLAINT_ORDER_DO.createTime,
                Q_COMPLAINT_ORDER_DO.modifyTime,
                Q_COMPLAINT_ORDER_DO.cancelReasonB,
                Q_COMPLAINT_ORDER_DO.cancelReasonC,
                Q_COMPLAINT_ORDER_DO.cancelDetail,
                Q_COMPLAINT_ORDER_DO.custName

        )).from(Q_COMPLAINT_ORDER_DO);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
            param.fillOrders(jpaQuery, Q_COMPLAINT_ORDER_DO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(Q_COMPLAINT_ORDER_DO.deleteFlag.eq(0).or(Q_COMPLAINT_ORDER_DO.deleteFlag.isNull()));

        return PagingVO.<ComplaintOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }

    public PagingVO<ComplaintOrderVO> exportQuery(ComplaintOrderPageParam param) {
        JPAQuery<CarOwnerVehicleInfoDO> leftOn = jpaQueryFactory.select(Q_CAR_OWNER_VEHICLE_INFO_DO).where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.isNotEmpty().and(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.isNotNull()));
        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.issueType,
                Q_COMPLAINT_ORDER_DO.issueDescription,
                Q_COMPLAINT_ORDER_DO.orderNo,
                Q_COMPLAINT_ORDER_DO.orderPerson,
                Q_COMPLAINT_ORDER_DO.orderTel,
                Q_COMPLAINT_ORDER_DO.vehicleNo,
                Q_COMPLAINT_ORDER_DO.vehicleType,
                Q_COMPLAINT_ORDER_DO.orderType,
                Q_COMPLAINT_ORDER_DO.orderStatus,
                Q_COMPLAINT_ORDER_DO.confirmType,
                Q_COMPLAINT_ORDER_DO.createTime,
                Q_COMPLAINT_ORDER_DO.remark,
                Q_COMPLAINT_ORDER_DO.custName,
                Q_ORDER_EVALUATION_DO.evaluationContent,
                Q_ORDER_EVALUATION_DO.evaluationLevel,
                Q_ORDER_EVALUATION_DO.createTime.as("evaluationTime"),
                Q_ORDER_EVALUATION_DO.returnLevel,
                Q_ORDER_EVALUATION_DO.returnAdvice,
                Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime,
                Q_COMPLAINT_ORDER_DO.custName
        )).from(Q_COMPLAINT_ORDER_DO).leftJoin(Q_ORDER_EVALUATION_DO).on(Q_COMPLAINT_ORDER_DO.id.eq(Q_ORDER_EVALUATION_DO.orderId))
                .leftJoin(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .on(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(Q_COMPLAINT_ORDER_DO.vehicleNo)
                        .and(Q_COMPLAINT_ORDER_DO.vehicleNo.isNotNull().and(Q_COMPLAINT_ORDER_DO.vehicleNo.ne("")).and(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0).or(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.isNull()))));
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
            param.fillOrders(jpaQuery, Q_COMPLAINT_ORDER_DO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(Q_COMPLAINT_ORDER_DO.deleteFlag.eq(0).or(Q_COMPLAINT_ORDER_DO.deleteFlag.isNull()));
        return PagingVO.<ComplaintOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }

    public PagingVO<ComplaintOrderVO> unEvaluationQuery(ComplaintOrderPageParam param) {
        Predicate onCondition = Q_COMPLAINT_ORDER_DO.id.eq(Q_ORDER_EVALUATION_DO.orderId);

        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.issueType,
                Q_COMPLAINT_ORDER_DO.issueDescription,
                Q_COMPLAINT_ORDER_DO.carOwnerId,
                Q_COMPLAINT_ORDER_DO.orderNo,
                Q_COMPLAINT_ORDER_DO.orderPerson,
                Q_COMPLAINT_ORDER_DO.orderTel,
                Q_COMPLAINT_ORDER_DO.vehicleNo,
                Q_COMPLAINT_ORDER_DO.vehicleType,
                Q_COMPLAINT_ORDER_DO.orderType,
                Q_COMPLAINT_ORDER_DO.orderStatus,
                Q_COMPLAINT_ORDER_DO.handlePersonName,
                Q_COMPLAINT_ORDER_DO.handlePersonTel,
                Q_COMPLAINT_ORDER_DO.handleReply,
                Q_COMPLAINT_ORDER_DO.baseNo,
                Q_COMPLAINT_ORDER_DO.confirmType,
                Q_COMPLAINT_ORDER_DO.issueSupplement,
                Q_COMPLAINT_ORDER_DO.subdivisionType,
                Q_COMPLAINT_ORDER_DO.dispatchPersonId,
                Q_COMPLAINT_ORDER_DO.timeoutStatus,
                Q_COMPLAINT_ORDER_DO.dispatchTime,
                Q_COMPLAINT_ORDER_DO.completeTime,
                Q_COMPLAINT_ORDER_DO.createTime,
                Q_COMPLAINT_ORDER_DO.modifyTime,
                Q_COMPLAINT_ORDER_DO.cancelReasonB,
                Q_COMPLAINT_ORDER_DO.cancelReasonC,
                Q_COMPLAINT_ORDER_DO.cancelDetail,
                Q_COMPLAINT_ORDER_DO.custName
        )).from(Q_COMPLAINT_ORDER_DO).leftJoin(Q_ORDER_EVALUATION_DO).on(onCondition);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
            param.fillOrders(jpaQuery, Q_COMPLAINT_ORDER_DO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(Q_ORDER_EVALUATION_DO.id.isNull());
        jpaQuery.where(Q_COMPLAINT_ORDER_DO.deleteFlag.eq(0).or(Q_COMPLAINT_ORDER_DO.deleteFlag.isNull()));

        return PagingVO.<ComplaintOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }

    public ComplaintOrderVO queryInfo(ComplaintOrderPageParam param) {

        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.issueType,
                Q_COMPLAINT_ORDER_DO.issueDescription,
                Q_COMPLAINT_ORDER_DO.carOwnerId,
                Q_COMPLAINT_ORDER_DO.orderNo,
                Q_COMPLAINT_ORDER_DO.orderPerson,
                Q_COMPLAINT_ORDER_DO.orderTel,
                Q_COMPLAINT_ORDER_DO.vehicleNo,
                Q_COMPLAINT_ORDER_DO.vehicleType,
                Q_COMPLAINT_ORDER_DO.orderType,
                Q_COMPLAINT_ORDER_DO.orderStatus,
                Q_COMPLAINT_ORDER_DO.handlePersonName,
                Q_COMPLAINT_ORDER_DO.handlePersonTel,
                Q_COMPLAINT_ORDER_DO.handleReply,
                Q_COMPLAINT_ORDER_DO.baseNo,
                Q_COMPLAINT_ORDER_DO.custName,
                Q_COMPLAINT_ORDER_DO.confirmType,
                Q_COMPLAINT_ORDER_DO.issueSupplement,
                Q_COMPLAINT_ORDER_DO.subdivisionType,
                Q_COMPLAINT_ORDER_DO.dispatchPersonId,
                Q_COMPLAINT_ORDER_DO.timeoutStatus,
                Q_COMPLAINT_ORDER_DO.dispatchTime,
                Q_COMPLAINT_ORDER_DO.completeTime,
                Q_COMPLAINT_ORDER_DO.createTime,
                Q_COMPLAINT_ORDER_DO.modifyTime,
                Q_COMPLAINT_ORDER_DO.cancelReasonB,
                Q_COMPLAINT_ORDER_DO.cancelReasonC,
                Q_COMPLAINT_ORDER_DO.cancelDetail
        )).from(Q_COMPLAINT_ORDER_DO).where(whereDtlParam(param));
        jpaQuery.where(Q_COMPLAINT_ORDER_DO.deleteFlag.eq(0).or(Q_COMPLAINT_ORDER_DO.deleteFlag.isNull()));
        return jpaQuery.fetchOne();
    }


    private Predicate whereDtlParam(ComplaintOrderPageParam param) {

        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        if (!StringUtils.isEmpty(param.getOrderType())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderType.eq(param.getOrderType()));
        }
        if (param.getId() != null  && param.getId() !=0) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.eq(param.getId()));
        }
        if (param.getIdList() != null  && !param.getIdList().isEmpty()) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.in(param.getIdList()));
        }
        if (param.getCarOwnerId() != null ) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.carOwnerId.eq(param.getCarOwnerId()));
        }
        if (param.getHandlePersonId() != null ) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.handlePersonId.eq(param.getHandlePersonId()));
        }
        if (!StringUtils.isEmpty(param.getOrderStatus())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderStatus.eq(param.getOrderStatus()));
        }
        if (!StringUtils.isEmpty(param.getOrderTel())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderTel.like("%" + param.getOrderTel() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOrderPerson())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderPerson.like("%" + param.getOrderPerson() + "%"));
        }
        if (!StringUtils.isEmpty(param.getIssueType())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.issueType.eq(param.getIssueType()));
        }
        if (!StringUtils.isEmpty(param.getOrderNo())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderNo.like("%" + param.getOrderNo() + "%"));
        }
        if (param.getStartTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.createTime.goe(param.getStartTime()));
        }
        if (param.getEndTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.createTime.loe(param.getEndTime()));
        }
        if (param.getActivatTimeStart() != null ){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime.goe(param.getActivatTimeStart()));
        }
        if (param.getActivatTimeEnd() != null){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime.loe(param.getActivatTimeEnd()));
        }
        if(param.getBindingTimeStart() != null){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime.goe(param.getBindingTimeStart()));
        }
        if(param.getBindingTimeEnd() != null){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime.loe(param.getBindingTimeEnd()));
        }
        if (!StringUtils.isEmpty(param.getSearchContent())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderNo.like("%" + param.getSearchContent() + "%").or(Q_COMPLAINT_ORDER_DO.issueDescription.like("%" + param.getSearchContent() + "%")));
        }
        if (!StringUtils.isEmpty(param.getTimeoutStatus())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.timeoutStatus.eq(param.getTimeoutStatus()));
        }
        if (!StringUtils.isEmpty(param.getVehicleNo())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.vehicleNo.eq(param.getVehicleNo()));
        }
        if (!StringUtils.isEmpty(param.getVehicleType())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.vehicleType.eq(param.getVehicleType()));
        }
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.custName.like("%" + param.getCustName() + "%"));
        }
        return predicate;
    }

    public void batchCancel(List<Long> ids) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.orderStatus, UdcEnum.COMPLAINT_ORDER_KSS004.getValueCode());
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.in(ids)));
        jpaUpdateClause.execute();
    }

    public void cancel(ComplaintOrderCancelParam param) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.orderStatus, UdcEnum.COMPLAINT_ORDER_KSS004.getValueCode());
        if(null != param.getCancelReasonB()) {
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.cancelReasonB, param.getCancelReasonB());
        }
        if(null != param.getCancelReasonC()) {
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.cancelReasonC, param.getCancelReasonC());
        }
        if(StringUtils.isNotEmpty(param.getCancelDetail())) {
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.cancelDetail, param.getCancelDetail());
        }
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.eq(param.getId())));
        jpaUpdateClause.execute();
    }

    public void deleteComplaint(List<Long> ids) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.deleteFlag, 1);
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.in(ids)));
        jpaUpdateClause.execute();
    }


    public void complaintOrderDispatch(ComplaintOrderParam saveVO) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        if(saveVO.getBaseNo() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.baseNo, saveVO.getBaseNo());
        }
        if(saveVO.getConfirmType() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.confirmType, saveVO.getConfirmType());
        }
        if(saveVO.getIssueSupplement() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.issueSupplement, saveVO.getIssueSupplement());
        }
        if(saveVO.getSubdivisionType() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.subdivisionType, saveVO.getSubdivisionType());
        }

        if(saveVO.getHandlePersonId() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.handlePersonId, saveVO.getHandlePersonId());
        }
        if(saveVO.getHandlePersonName() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.handlePersonName, saveVO.getHandlePersonName());
        }
        if(saveVO.getHandlePersonTel() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.handlePersonTel, saveVO.getHandlePersonTel());
        }
        jpaUpdateClause
                .set(Q_COMPLAINT_ORDER_DO.dispatchTime, LocalDateTime.now())
                .set(Q_COMPLAINT_ORDER_DO.dispatchPersonId, saveVO.getDispatchPersonId())
                .set(Q_COMPLAINT_ORDER_DO.orderStatus, UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode())
                .set(Q_COMPLAINT_ORDER_DO.timeoutStatus, UdcEnum.TIMEOUT_STATUS_1.getValueCode());
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.eq(saveVO.getId())));
        jpaUpdateClause.execute();
    }

    public void complaintOrderComplete(ComplaintOrderParam saveVO) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.orderStatus, UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
        if(saveVO.getHandleReply() != null){
            jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.handleReply, saveVO.getHandleReply());
        }
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.completeTime, LocalDateTime.now());
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.eq(saveVO.getId())));
        jpaUpdateClause.execute();
    }

    public List<ComplaintOrderVO> findComplaintOrderByTime(LocalDateTime start, Integer limit){
        Predicate onPredicate = Q_COMPLAINT_ORDER_DO.id.eq(Q_ORDER_EVALUATION_DO.orderId);
        Predicate wherePredicate = Q_COMPLAINT_ORDER_DO.orderStatus.eq(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.completeTime.loe(start));
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_ORDER_EVALUATION_DO.id.isNull());
        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.completeTime
        )).from(Q_COMPLAINT_ORDER_DO).leftJoin(Q_ORDER_EVALUATION_DO)
                .on(onPredicate).where(wherePredicate)
                .orderBy(Q_COMPLAINT_ORDER_DO.completeTime.asc()).limit(limit);

        return jpaQuery.fetch();
    }

    public PagingVO<ComplaintOrderVO> findPageComplaintOrder(ComplaintOrderPageParam param, LocalDateTime time){
        Predicate onPredicate = Q_COMPLAINT_ORDER_DO.id.eq(Q_ORDER_EVALUATION_DO.orderId);
        Predicate wherePredicate = Q_COMPLAINT_ORDER_DO.orderStatus.eq(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.completeTime.loe(time));
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_ORDER_EVALUATION_DO.id.isNull());
        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.completeTime
        )).from(Q_COMPLAINT_ORDER_DO).leftJoin(Q_ORDER_EVALUATION_DO)
                .on(onPredicate).where(wherePredicate);

        param.fillOrders(jpaQuery, Q_COMPLAINT_ORDER_DO);
        param.setPaging(jpaQuery);
        return PagingVO.<ComplaintOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<RepairOrderVO> findPageRepairOrder(ComplaintOrderPageParam param, LocalDateTime time){
        Predicate onPredicate = Q_REPAIR_ORDER_DO.id.eq(Q_ORDER_EVALUATION_DO.orderId);
        Predicate wherePredicate = Q_REPAIR_ORDER_DO.orderStatus.eq(UdcEnum.REPAIR_ORDER_JSS003.getValueCode());
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_ORDER_EVALUATION_DO.id.isNull());
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_REPAIR_ORDER_DO.modifyTime.loe(time));
        JPAQuery<RepairOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                RepairOrderVO.class,
                Q_REPAIR_ORDER_DO.id,
                Q_REPAIR_ORDER_DO.modifyTime
        )).from(Q_REPAIR_ORDER_DO).leftJoin(Q_ORDER_EVALUATION_DO)
                .on(onPredicate).where(wherePredicate);

        param.fillOrders(jpaQuery, Q_REPAIR_ORDER_DO);
        param.setPaging(jpaQuery);
        return PagingVO.<RepairOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public void rspTimeOut(List<Long> ids) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.in(ids));
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.timeoutStatus, UdcEnum.TIMEOUT_STATUS_2.getValueCode());
        jpaUpdateClause.where(predicate);
        jpaUpdateClause.execute();
    }

    public PagingVO<ComplaintOrderVO> findPageTimeout(ComplaintOrderPageParam param, String type){
        Predicate wherePredicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        if("handle".equals(type)) {
            wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.orderStatus.eq(UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode()));
            wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.timeoutStatus.eq(UdcEnum.TIMEOUT_STATUS_1.getValueCode())
                    .or(Q_COMPLAINT_ORDER_DO.timeoutStatus.eq(UdcEnum.TIMEOUT_STATUS_2.getValueCode())));
        }else if("rsp".equals(type)){
            wherePredicate = Q_COMPLAINT_ORDER_DO.orderStatus.eq(UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode());
            wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.timeoutStatus.eq(UdcEnum.TIMEOUT_STATUS_1.getValueCode()));
        }else {
            throw new BusinessException(ApiCode.FAIL, "超时类型错误");
        }
        wherePredicate = ExpressionUtils.and(wherePredicate, Q_COMPLAINT_ORDER_DO.orderType.eq(UdcEnum.ORDER_TYPE_2.getValueCode()));

        JPAQuery<ComplaintOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ComplaintOrderVO.class,
                Q_COMPLAINT_ORDER_DO.id,
                Q_COMPLAINT_ORDER_DO.orderType,
                Q_COMPLAINT_ORDER_DO.issueType,
                Q_COMPLAINT_ORDER_DO.createTime,
                Q_COMPLAINT_ORDER_DO.completeTime,
                Q_COMPLAINT_ORDER_DO.dispatchTime
        )).from(Q_COMPLAINT_ORDER_DO);
        param.fillOrders(jpaQuery, Q_COMPLAINT_ORDER_DO);
        param.setPaging(jpaQuery);
        jpaQuery.where(wherePredicate);

        return PagingVO.<ComplaintOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public void handleTimeOut(List<Long> ids) {
        Predicate predicate = Q_COMPLAINT_ORDER_DO.isNotNull();
        predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.id.in(ids));
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_ORDER_DO);
        jpaUpdateClause.set(Q_COMPLAINT_ORDER_DO.timeoutStatus, UdcEnum.TIMEOUT_STATUS_3.getValueCode());
        jpaUpdateClause.where(predicate);
        jpaUpdateClause.execute();
    }
}
