package com.elitesland.yst.production.aftersale.service.repo;

import com.elitesland.yst.production.aftersale.model.entity.ComplaintSetDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author elvis.hong
 * @title ComplaintSetRepo
 * @Date 2023/3/1 16:44
 */
@Repository
public interface ComplaintSetRepo extends JpaRepository<ComplaintSetDO, Long>, QuerydslPredicateExecutor<ComplaintSetDO> {

    /**
     * 查询相同的父类下是否有相同的名称
     *
     * @param complainName
     * @param pid
     * @return
     */
    boolean existsByClassifyNameAndPid(String complainName, Long pid);

    /**
     * 查询相同的父类下除自己外是否有相同的名称
     * @param classifyName
     * @param pid
     * @param id
     * @return
     */
    boolean existsByClassifyNameAndPidAndIdNot(String classifyName, Long pid, Long id);


    /**
     * 判断是否存在下级
     *
     * @param ids
     * @return
     */
    Boolean existsByPidIn(List<Long> ids);


    /**
     * 根据客诉类型查询
     *
     * @param complaintType
     * @return
     */
    List<ComplaintSetDO> findByComplaintType(String complaintType);
}
