package com.elitesland.yst.production.aftersale.service.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.QOrderLogDO;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.querydsl.core.types.*;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.List;


@Repository
public class OrderLogRepoProc extends BaseRepoProc<OrderLogDO> {
    private static final QOrderLogDO QDO = QOrderLogDO.orderLogDO;

    protected OrderLogRepoProc() {
        super(QDO);
    }




    public List<OrderLogVO> query(OrderLogPageParam orderLogPageParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(orderLogPageParam.getOrderId() != null, QDO.orderId, orderLogPageParam.getOrderId())
                .andIn(!CollectionUtils.isEmpty(orderLogPageParam.getOrderIdList()), QDO.orderId, orderLogPageParam.getOrderIdList())
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(QDO)
                .where(predicate)
                .orderBy(QDO.createTime.desc())
                .fetch();
    }


    private QBean<OrderLogVO> fieldsOfYstDemoDTO() {
        return Projections.bean(OrderLogVO.class,
                QDO.id,
                QDO.orderId,
                QDO.orderType,
                QDO.operationContent,
                QDO.remark,
                QDO.operationTime,
                QDO.operationUser,
                QDO.operationUserId
        );
    }
}
