package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecClsDO;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.QPhoneRecClsDO;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecClsRespVO;
import com.elitesland.yst.production.aftersale.model.vo.query.PhoneRecClsQueryVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Repository
public class PhoneRecClsRepoProc  extends BaseRepoProc<PhoneRecClsDO> {
    private static final QPhoneRecClsDO qComClgClassDO = QPhoneRecClsDO.phoneRecClsDO;

    protected PhoneRecClsRepoProc() {
        super(qComClgClassDO);
    }


    public Long updateDeleteFlag(List<Long> ids){
        return jpaQueryFactory.update(qComClgClassDO)
                .set(qComClgClassDO.deleteFlag, 1)
                .where(qComClgClassDO.id.in(ids))
                .execute();
    }

    public JPAQuery<PhoneRecClsRespVO> queryByPage(PhoneRecClsQueryVO param){
        JPAQuery<PhoneRecClsRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PhoneRecClsRespVO.class,
                qComClgClassDO.id,
                qComClgClassDO.name,
                qComClgClassDO.pid,
                qComClgClassDO.sortNo,
                qComClgClassDO.descr))
                .from(qComClgClassDO)
                .where(where(param));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, qComClgClassDO);
        return jpaQuery;
    }

    public Predicate where(PhoneRecClsQueryVO param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);

        if (StringUtils.isNotBlank(param.getName())){
            String like = "%" + param.getName() + "%";
            predicate = ExpressionUtils.and(predicate, qComClgClassDO.name.like(like));
        }
        return predicate;
    }
}
