package com.elitesland.yst.production.aftersale.service.repo;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.QPhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.QPhoneRecClsDO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录RepoProc
 */
@Component
public class PhoneRecordRepoProc extends BaseRepoProc<PhoneRecordDO> {


    private static final QPhoneRecordDO qPhoneRecordDO = QPhoneRecordDO.phoneRecordDO;
    private static final QPhoneRecClsDO qComClgClassDO = new QPhoneRecClsDO("comClgClassDO");
    private static final QPhoneRecClsDO qSubComClgClassDO = new QPhoneRecClsDO("subComClgClassDO");

    protected PhoneRecordRepoProc() {
        super(qPhoneRecordDO);
    }


    public PagingVO<PhoneRecordVO> page(PhoneRecordPageParam phoneRecordPageParam) {
        JPAQuery<PhoneRecordVO> query = select(PhoneRecordVO.class)
                .where(bulidPredicate(phoneRecordPageParam));
        phoneRecordPageParam.setPaging(query);
        phoneRecordPageParam.fillOrders(query, qPhoneRecordDO);
        return PagingVO.<PhoneRecordVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qPhoneRecordDO)
                .set(qPhoneRecordDO.deleteFlag, 1)
                .where(qPhoneRecordDO.id.in(ids))
                .execute();
        return res;
    }


    public PhoneRecordVO get(Long id) {
        PhoneRecordVO phoneRecordVO = select(PhoneRecordVO.class)
                .where(qPhoneRecordDO.id.eq(id))
                .fetchOne();
        return phoneRecordVO;
    }


    public List<PhoneRecordVO> getList(PhoneRecordPageParam phoneRecordPageParam) {
        List<PhoneRecordVO> res = select(PhoneRecordVO.class)
                .where(bulidPredicate(phoneRecordPageParam))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPhoneRecordDO.recordTime,
                qPhoneRecordDO.cityCode,
                qPhoneRecordDO.cityName,
                qPhoneRecordDO.addr,
                qPhoneRecordDO.contacts,
                qPhoneRecordDO.contactPhone,
                qPhoneRecordDO.custType,
                qPhoneRecordDO.callType,
                qComClgClassDO.name.as("callTypeName"),
                qPhoneRecordDO.subCallType,
                qSubComClgClassDO.name.as("subCallTypeName"),
                qPhoneRecordDO.callContent,
                qPhoneRecordDO.processResult,
                qPhoneRecordDO.relevantDepartment,
                qPhoneRecordDO.followUpFlag,
                qPhoneRecordDO.serviceSatisfied,
                qPhoneRecordDO.otherOpinion,
                qPhoneRecordDO.id,
                qPhoneRecordDO.createTime,
                qPhoneRecordDO.remark,
                qPhoneRecordDO.creator,
                qPhoneRecordDO.createName,
                qPhoneRecordDO.callBackTime
        )).from(qPhoneRecordDO)
            .leftJoin(qComClgClassDO).on(qComClgClassDO.code.eq(qPhoneRecordDO.callType))
            .leftJoin(qSubComClgClassDO).on(qSubComClgClassDO.code.eq(qPhoneRecordDO.subCallType));
    }


    private Predicate bulidPredicate(PhoneRecordPageParam phoneRecordPageParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andGoe(null != phoneRecordPageParam.getRecordTimeStart(), qPhoneRecordDO.recordTime, phoneRecordPageParam.getRecordTimeStart())
                .andLoe(null != phoneRecordPageParam.getRecordTimeEnd(), qPhoneRecordDO.recordTime, phoneRecordPageParam.getRecordTimeEnd())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getCityCode()), qPhoneRecordDO.cityCode, phoneRecordPageParam.getCityCode())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getCityName()), qPhoneRecordDO.cityName, phoneRecordPageParam.getCityName())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getAddr()), qPhoneRecordDO.addr, phoneRecordPageParam.getAddr())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getContacts()), qPhoneRecordDO.contacts, phoneRecordPageParam.getContacts())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getContactPhone()), qPhoneRecordDO.contactPhone, phoneRecordPageParam.getContactPhone())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getCustType()), qPhoneRecordDO.custType, phoneRecordPageParam.getCustType())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getCallType()), qPhoneRecordDO.callType, phoneRecordPageParam.getCallType())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getCallContent()), qPhoneRecordDO.callContent, phoneRecordPageParam.getCallContent())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getProcessResult()), qPhoneRecordDO.processResult, phoneRecordPageParam.getProcessResult())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getRelevantDepartment()), qPhoneRecordDO.relevantDepartment, phoneRecordPageParam.getRelevantDepartment())
                .andEq(null != phoneRecordPageParam.getFollowUpFlag(), qPhoneRecordDO.followUpFlag, phoneRecordPageParam.getFollowUpFlag())
                .andEq(null != phoneRecordPageParam.getServiceSatisfied(), qPhoneRecordDO.serviceSatisfied, phoneRecordPageParam.getServiceSatisfied())
                .andEq(StringUtils.isNotBlank(phoneRecordPageParam.getOtherOpinion()), qPhoneRecordDO.otherOpinion, phoneRecordPageParam.getOtherOpinion())
                .andIn(!CollectionUtils.isEmpty(phoneRecordPageParam.getIds()), qPhoneRecordDO.id, phoneRecordPageParam.getIds())
                .build();
        return predicate;
    }


    private List<Predicate> bulidPredicates(PhoneRecordPageParam phoneRecordPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 记录日期
        if (null != phoneRecordPageParam.getRecordTimeStart()) {
            predicates.add(qPhoneRecordDO.recordTime.eq(phoneRecordPageParam.getRecordTimeStart()));
        }
        // 城市编码
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getCityCode())) {
            predicates.add(qPhoneRecordDO.cityCode.eq(phoneRecordPageParam.getCityCode()));
        }
        // 城市名称
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getCityName())) {
            predicates.add(qPhoneRecordDO.cityName.eq(phoneRecordPageParam.getCityName()));
        }
        // 地址
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getAddr())) {
            predicates.add(qPhoneRecordDO.addr.eq(phoneRecordPageParam.getAddr()));
        }
        // 联络人
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getContacts())) {
            predicates.add(qPhoneRecordDO.contacts.eq(phoneRecordPageParam.getContacts()));
        }
        // 联系电话
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getContactPhone())) {
            predicates.add(qPhoneRecordDO.contactPhone.eq(phoneRecordPageParam.getContactPhone()));
        }
        // 客户类型
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getCustType())) {
            predicates.add(qPhoneRecordDO.custType.eq(phoneRecordPageParam.getCustType()));
        }
        // 来电类型
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getCallType())) {
            predicates.add(qPhoneRecordDO.callType.eq(phoneRecordPageParam.getCallType()));
        }
        // 来电内容
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getCallContent())) {
            predicates.add(qPhoneRecordDO.callContent.eq(phoneRecordPageParam.getCallContent()));
        }
        // 处理结果
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getProcessResult())) {
            predicates.add(qPhoneRecordDO.processResult.eq(phoneRecordPageParam.getProcessResult()));
        }
        // 相关部门
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getRelevantDepartment())) {
            predicates.add(qPhoneRecordDO.relevantDepartment.eq(phoneRecordPageParam.getRelevantDepartment()));
        }
        // 是否回访
        if (null != phoneRecordPageParam.getFollowUpFlag()) {
            predicates.add(qPhoneRecordDO.followUpFlag.eq(phoneRecordPageParam.getFollowUpFlag()));
        }
        // 服务满意度
        if (null != phoneRecordPageParam.getServiceSatisfied()) {
            predicates.add(qPhoneRecordDO.serviceSatisfied.eq(phoneRecordPageParam.getServiceSatisfied()));
        }
        // 其他意见
        if (StringUtils.isNotEmpty(phoneRecordPageParam.getOtherOpinion())) {
            predicates.add(qPhoneRecordDO.otherOpinion.eq(phoneRecordPageParam.getOtherOpinion()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


}