package com.elitesland.yst.production.aftersale.service.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.QPictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.util.BuildFilPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import io.jsonwebtoken.lang.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class PictureOrderRepoProc extends BaseRepoProc<PictureOrderDO> {
    private static final QPictureOrderDO QDO = QPictureOrderDO.pictureOrderDO;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String FILE_URL = "file.upload.url";


    protected PictureOrderRepoProc() {
        super(QDO);
    }




    public List<PictureOrderVO> query(PictureOrderParam queryDTO) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(queryDTO.getId() != null, QDO.id, queryDTO.getId())
                .andIn(!Collections.isEmpty(queryDTO.getOrderList()), QDO.orderId, queryDTO.getOrderList())
                .andEq(queryDTO.getOrderType() != null, QDO.orderType, queryDTO.getOrderType())
                .build();

        List<PictureOrderVO> fetch = jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(QDO)
                .where(predicate)
                .fetch();
        //
        fetch.stream().filter(a -> StringUtils.isNotEmpty(a.getUrl())  && !a.getUrl().startsWith("http")).forEach(t ->{
            t.setUrl(buildFilePath(t.getUrl()));
        });

        return fetch;
    }
    public String buildFilePath(String result) {

        String fileUrl = applicationContext.getEnvironment().getProperty(FILE_URL);
        if (org.apache.commons.lang.StringUtils.isNotEmpty(fileUrl)) {
            return fileUrl + result;
        }
        return null;
    }


    private QBean<PictureOrderVO> fieldsOfYstDemoDTO() {
        return Projections.bean(PictureOrderVO.class,
                QDO.id,
                QDO.updater,
                QDO.secUserId,
                QDO.secBuId,
                QDO.secOuId,
                QDO.deleteFlag,
                QDO.creator,
                QDO.createTime,
                QDO.createUserId,
                QDO.url,
                QDO.code,
                QDO.orderId,
                QDO.orderType
        );
    }
}
