package com.elitesland.yst.production.aftersale.service.repo;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.QRepairOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairOrderDO;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;


@Repository
public class RepairOrderRepoProc extends BaseRepoProc<RepairOrderDO> {
    private static final QRepairOrderDO QDO = QRepairOrderDO.repairOrderDO;

    protected RepairOrderRepoProc() {
        super(QDO);
    }




    public PagingVO<RepairOrderVO> query(RepairOrderExlParam param) {

        JPAQuery<RepairOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                        RepairOrderVO.class,
                        QDO.id,
                        QDO.vehicleNo,
                        QDO.vehicleType,
                        QDO.orderNo,
                        QDO.orderStatus,
                        QDO.updater,
                        QDO.secUserId,
                        QDO.secBuId,
                        QDO.secOuId,
                        QDO.repairStoreCode,
                        QDO.repairStoreName,
                        QDO.deleteFlag,
                        QDO.creator,
                        QDO.createTime,
                        QDO.modifyTime,
                        QDO.createUserId,
                        QDO.orderPerson,
                        QDO.orderTel,
                        QDO.personalId,
                        QDO.personalVehicelId,
                        QDO.questionRemark,
                        QDO.repairStoreId,
                        QDO.questionType,
                        QDO.repairMode,
                        QDO.receiveOrderTime,
                        QDO.completeTime,
                        QDO.cancelReasonC,
                        QDO.cancelReasonB,
                        QDO.cancelRemark,
                        QDO.repairRemark,
                        QDO.salesman,
                        QDO.salesmanId,
                        QDO.remark,
                        QDO.serviceType
                )).from(QDO);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
            param.fillOrders(jpaQuery, QDO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(QDO.deleteFlag.eq(0).or(QDO.deleteFlag.isNull()));

        return PagingVO.<RepairOrderVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }
    public List<RepairOrderVO> detail(RepairOrderExlParam param) {

        JPAQuery<RepairOrderVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                RepairOrderVO.class,
                QDO.id,
                QDO.vehicleNo,
                QDO.vehicleType,
                QDO.orderNo,
                QDO.orderStatus,
                QDO.updater,
                QDO.secUserId,
                QDO.secBuId,
                QDO.secOuId,
                QDO.deleteFlag,
                QDO.creator,
                QDO.createTime,
                QDO.modifyTime,
                QDO.createUserId,
                QDO.orderPerson,
                QDO.orderTel,
                QDO.personalId,
                QDO.personalVehicelId,
                QDO.questionRemark,
                QDO.repairStoreId,
                QDO.questionType,
                QDO.repairMode,
                QDO.receiveOrderTime,
                QDO.completeTime,
                QDO.cancelReasonC,
                QDO.cancelReasonB,
                QDO.cancelRemark,
                QDO.repairRemark,
                QDO.repairStoreName,
                QDO.repairStoreCode,
                QDO.purchaseStoreId,
                QDO.purchaseStoreCode,
                QDO.purchaseStoreName,
                QDO.purchaseTime,
                QDO.salesman,
                QDO.salesmanId,
                QDO.remark,
                QDO.serviceType,
                QDO.vehicleSource,
                QDO.brandName
        )).from(QDO);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
        }
        jpaQuery.where(QDO.deleteFlag.eq(0).or(QDO.deleteFlag.isNull()));

        return jpaQuery.fetch();

    }


    private Predicate whereDtlParam(RepairOrderExlParam param) {

        Predicate predicate = QDO.isNotNull();
        if (param.getId() != null  && param.getId() !=0) {
            predicate = ExpressionUtils.and(predicate, QDO.id.eq(param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, QDO.id.in(param.getIdList()));
        }
        if (param.getPersonalId() != null ) {
            predicate = ExpressionUtils.and(predicate, QDO.personalId.eq(param.getPersonalId()));
        }
        if (!StringUtils.isEmpty(param.getOrderStatus())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderStatus.eq(param.getOrderStatus()));
        }
        if (!StringUtils.isEmpty(param.getVehicleNo())) {
            predicate = ExpressionUtils.and(predicate, QDO.vehicleNo.like("%" + param.getVehicleNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getStoreNameAndCode())) {
            predicate = ExpressionUtils.and(predicate, QDO.repairStoreCode.like("%" + param.getStoreNameAndCode() + "%").or(QDO.repairStoreName.like("%" + param.getStoreNameAndCode() + "%")));
        }
        if (!StringUtils.isEmpty(param.getRepairStoreName())) {
            predicate = ExpressionUtils.and(predicate, QDO.repairStoreName.like("%" + param.getRepairStoreName() + "%"));
        }
        if (!StringUtils.isEmpty(param.getRepairStoreCode())) {
            predicate = ExpressionUtils.and(predicate, QDO.repairStoreCode.like("%" + param.getRepairStoreCode() + "%"));
        }
        if (!StringUtils.isEmpty(param.getCustNameAndPhone())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderPerson.like("%" + param.getCustNameAndPhone() + "%").or(QDO.orderTel.like("%" + param.getCustNameAndPhone() + "%")));
        }
        if (!StringUtils.isEmpty(param.getOrderNoAndCustPhone())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderNo.like("%" + param.getOrderNoAndCustPhone() + "%").or(QDO.orderTel.like("%" + param.getOrderNoAndCustPhone() + "%")));
        }
        if (!StringUtils.isEmpty(param.getOrderNo())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderNo.like("%" + param.getOrderNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOrderTel())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderTel.like("%" + param.getOrderTel() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOrderPerson())) {
            predicate = ExpressionUtils.and(predicate, QDO.orderPerson.like("%" + param.getOrderPerson() + "%"));
        }
        if(Objects.nonNull(param.getCreateTimeFrom())){
            predicate = ExpressionUtils.and(predicate,QDO.createTime.goe(param.getCreateTimeFrom()));
        }
        if(Objects.nonNull(param.getCreateTimeTo())){
            predicate = ExpressionUtils.and(predicate,QDO.createTime.loe(param.getCreateTimeTo()));
        }
        if(!CollectionUtils.isEmpty(param.getRepairStoreIdS())){
            predicate = ExpressionUtils.and(predicate,QDO.repairStoreId.in(param.getRepairStoreIdS()));
        }
        if(!CollectionUtils.isEmpty(param.getOrderStatusList())){
            predicate = ExpressionUtils.and(predicate,QDO.orderStatus.in(param.getOrderStatusList()));
        }
        return predicate;
    }

    @Transactional(rollbackFor = Exception.class)
    public void cancel(RepairOrderParam param) {
        Predicate predicate = QDO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(QDO);
        jpaUpdateClause.set(QDO.orderStatus, UdcEnum.REPAIR_ORDER_JSS004.getValueCode());
        if(null != param.getCancelReasonB()) {
            jpaUpdateClause.set(QDO.cancelReasonB, param.getCancelReasonB());
        }
        if(null != param.getCancelReasonC()) {
            jpaUpdateClause.set(QDO.cancelReasonC, param.getCancelReasonC());
        }
        if(StringUtils.isNotEmpty(param.getCancelRemark())) {
            jpaUpdateClause.set(QDO.cancelRemark, param.getCancelRemark());
        }
        jpaUpdateClause.where(ExpressionUtils.and(predicate, QDO.id.eq(param.getId())));
        jpaUpdateClause.execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteList(List<Long> idList) {
        Predicate predicate = QDO.isNotNull();
        jpaQueryFactory.update(QDO)
                .set(QDO.deleteFlag, 1)
                .where(ExpressionUtils.and(predicate, QDO.id.in(idList))).execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateStatus(Long id, String orderStatus,String remark) {
        Predicate predicate = QDO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(QDO)
                .set(QDO.orderStatus, orderStatus)
                .set(QDO.repairRemark, remark)
                .where(ExpressionUtils.and(predicate, QDO.id.eq(id)));
        jpaUpdateClause.execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateSupplyStatus(Long id, String remark) {
        Predicate predicate = QDO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(QDO)
                .set(QDO.repairRemark, remark)
                .where(ExpressionUtils.and(predicate, QDO.id.eq(id)));
        jpaUpdateClause.execute();
    }
    @Transactional(rollbackFor = Exception.class)
    public void updateCarMessageAndStatus(RepairOrderParam repairOrderParam,Long purchaseStoreId,String purchaseStoreCode, String purchaseStoreName) {
        Predicate predicate = QDO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(QDO)
                .set(QDO.personalVehicelId, repairOrderParam.getPersonalVehicelId())
                .set(QDO.brandName, repairOrderParam.getBrandName())
                .set(QDO.vehicleSource, repairOrderParam.getVehicleSource())
                .set(QDO.vehicleNo, repairOrderParam.getVehicleNo())
                .set(QDO.vehicleType, repairOrderParam.getVehicleType())
                .set(QDO.purchaseTime, repairOrderParam.getPurchaseTime())
                .set(QDO.purchaseStoreId, purchaseStoreId)
                .set(QDO.purchaseStoreCode, purchaseStoreCode)
                .set(QDO.purchaseStoreName, purchaseStoreName)
                .set(QDO.orderStatus, repairOrderParam.getOrderStatus())
                .where(ExpressionUtils.and(predicate, QDO.id.eq(repairOrderParam.getId())));
        jpaUpdateClause.execute();
    }
    @Transactional(rollbackFor = Exception.class)
    public void updateSupplyCarMessage(RepairOrderParam repairOrderParam,Long purchaseStoreId,String purchaseStoreCode, String purchaseStoreName) {
        Predicate predicate = QDO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(QDO)
                .set(QDO.personalVehicelId, repairOrderParam.getPersonalVehicelId())
                .set(QDO.vehicleSource, repairOrderParam.getVehicleSource())
                .set(QDO.brandName, repairOrderParam.getBrandName())
                .set(QDO.vehicleNo, repairOrderParam.getVehicleNo())
                .set(QDO.vehicleType, repairOrderParam.getVehicleType())
                .set(QDO.purchaseTime, repairOrderParam.getPurchaseTime())
                .set(QDO.purchaseStoreId, purchaseStoreId)
                .set(QDO.purchaseStoreCode, purchaseStoreCode)
                .set(QDO.purchaseStoreName, purchaseStoreName)
                .where(ExpressionUtils.and(predicate, QDO.id.eq(repairOrderParam.getId())));
        jpaUpdateClause.execute();
    }
}
