package com.elitesland.yst.production.aftersale.service.repo;


import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairPartsServiceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public interface RepairPartsServiceRepo extends JpaRepository<RepairPartsServiceDO, Long>, QuerydslPredicateExecutor<RepairPartsServiceDO> {

    List<RepairPartsServiceDO> findByRepairId(Long id);

    @Transactional(rollbackFor = Exception.class)
    void deleteByRepairId(Long repairId);
}
