package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.QTemTransmissionLogDO;
import com.elitesland.yst.production.aftersale.model.entity.TemTransmissionLogDO;
import com.elitesland.yst.production.aftersale.model.param.TemTransmissionLogPageParam;
import com.elitesland.yst.production.aftersale.model.vo.TemTransmissionLogVO;
import org.springframework.stereotype.Component;

import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import com.querydsl.core.types.ExpressionUtils;
import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-5-24
 * @desc : 传输日志记录表RepoProc
 */

@Component
public class TemTransmissionLogRepoProc extends BaseRepoProc<TemTransmissionLogDO> {

    private static final QTemTransmissionLogDO qTemTransmissionLogDO = QTemTransmissionLogDO.temTransmissionLogDO;


    protected TemTransmissionLogRepoProc() {

        super(qTemTransmissionLogDO);

    }


    public PagingVO<TemTransmissionLogVO> page(TemTransmissionLogPageParam temTransmissionLogPageParam) {

        JPAQuery<TemTransmissionLogVO> query = select(TemTransmissionLogVO.class)
                .where(bulidPredicate(temTransmissionLogPageParam));
        temTransmissionLogPageParam.setPaging(query);
        temTransmissionLogPageParam.fillOrders(query, qTemTransmissionLogDO);
        return PagingVO.<TemTransmissionLogVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qTemTransmissionLogDO)
                .set(qTemTransmissionLogDO.deleteFlag, 1)
                .where(qTemTransmissionLogDO.id.in(ids))
                .execute();

        return res;

    }


    public TemTransmissionLogVO get(Long id) {

        TemTransmissionLogVO temTransmissionLogVO = select(TemTransmissionLogVO.class)
                .where(qTemTransmissionLogDO.id.eq(id))
                .fetchOne();

        return temTransmissionLogVO;

    }


    public List<TemTransmissionLogVO> getList(TemTransmissionLogPageParam temTransmissionLogPageParam) {

        List<TemTransmissionLogVO> res = select(TemTransmissionLogVO.class)
                .where(bulidPredicate(temTransmissionLogPageParam))
                .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qTemTransmissionLogDO.fromStr,
                        qTemTransmissionLogDO.dealFlag,
                        qTemTransmissionLogDO.sourcePlatform,
                        qTemTransmissionLogDO.retStr,
                        qTemTransmissionLogDO.retNum,
                        qTemTransmissionLogDO.id,
                        qTemTransmissionLogDO.createTime,
                        qTemTransmissionLogDO.remark

                )).from(qTemTransmissionLogDO);

    }


    private Predicate bulidPredicate(TemTransmissionLogPageParam temTransmissionLogPageParam) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(temTransmissionLogPageParam.getFromStr()), qTemTransmissionLogDO.fromStr, temTransmissionLogPageParam.getFromStr())
                .andEq(null != temTransmissionLogPageParam.getDealFlag(), qTemTransmissionLogDO.dealFlag, temTransmissionLogPageParam.getDealFlag())
                .andEq(StringUtils.isNotBlank(temTransmissionLogPageParam.getSourcePlatform()), qTemTransmissionLogDO.sourcePlatform, temTransmissionLogPageParam.getSourcePlatform())
                .andEq(StringUtils.isNotBlank(temTransmissionLogPageParam.getRetStr()), qTemTransmissionLogDO.retStr, temTransmissionLogPageParam.getRetStr())
                .andEq(null != temTransmissionLogPageParam.getRetNum(), qTemTransmissionLogDO.retNum, temTransmissionLogPageParam.getRetNum())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(TemTransmissionLogPageParam temTransmissionLogPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 源参数
        if (StringUtils.isNotEmpty(temTransmissionLogPageParam.getFromStr())) {
            predicates.add(qTemTransmissionLogDO.fromStr.eq(temTransmissionLogPageParam.getFromStr()));
        }
        // 成功标记
        if (null != temTransmissionLogPageParam.getDealFlag()) {
            predicates.add(qTemTransmissionLogDO.dealFlag.eq(temTransmissionLogPageParam.getDealFlag()));
        }
        // 来源平台
        if (StringUtils.isNotEmpty(temTransmissionLogPageParam.getSourcePlatform())) {
            predicates.add(qTemTransmissionLogDO.sourcePlatform.eq(temTransmissionLogPageParam.getSourcePlatform()));
        }
        // 返回响应
        if (StringUtils.isNotEmpty(temTransmissionLogPageParam.getRetStr())) {
            predicates.add(qTemTransmissionLogDO.retStr.eq(temTransmissionLogPageParam.getRetStr()));
        }
        // 返回数量
        if (null != temTransmissionLogPageParam.getRetNum()) {
            predicates.add(qTemTransmissionLogDO.retNum.eq(temTransmissionLogPageParam.getRetNum()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


}
