package com.elitesland.yst.production.aftersale.controller.app;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Context:
 * @title: ThreePackageController
 * @Author： 郑杰
 * @Date: 2023/2/14 16:23
 */
@RestController
@RequestMapping(value = "/app/threePackage", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "三包", tags = {"三包"})
public class MaintainCardController {

    @Autowired
    private MaintainCardService maintainCardService;

    //    @Autowired
//    private CarOwnerVehicleService carOwnerVehicleService;
    @Autowired
    private RepairOrderService repairOrderService;


    @PostMapping(value = "/activateThreePackage")
    @ApiOperation(value = "三包激活")
    public ApiResult<Object> activateThreePackage(@RequestBody @Valid CarMaintainCardParam carMaintainCardParam) {

        throw new BusinessException("该接口已进行升级,请升级APP新版本");
//        carMaintainCardParam.setSourcePlatform("APP");
//        ApiResult<Object> activate = maintainCardService.activate(carMaintainCardParam);
//        return activate;
    }


    @PostMapping(value = "/activateThreePackage2")
    @ApiOperation(value = "三包激活-绑定车辆")
    public ApiResult<Object> activateThreePackage2(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {

        if (null == (carOwnerVehicleParam.getCarOwnerId())) {
            throw new BusinessException("carOwnerId不能为空");
        }
        carOwnerVehicleParam.setActivatFlag(true);
        carOwnerVehicleParam.setActivatTime(LocalDateTime.now());
        Boolean res = null;
        try {
            res = maintainCardService.activateThreePackage2(carOwnerVehicleParam, "APP");
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok(res);
    }


    @PostMapping(value = "/threePackageQuery")
    @ApiOperation(value = "三包查询")
    public ApiResult<Object> threePackageQuery(@RequestBody CarOwnerMaintainCardParam car) {
        ApiResult<Object> query = maintainCardService.query(car.getCarOwnerId(), car.getPage(), car.getPageSize());
        return query;
    }


    @PostMapping(value = "/page")
    @ApiOperation(value = "三包分页查询")
    public ApiResult<PagingVO<CarMaintainCardVO>> page(@RequestBody CarOwnerMaintainCardPageParam car) {

        // 当前登录人所属门店
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = repairOrderService.repairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        PagingVO<CarMaintainCardVO> res = maintainCardService.pageApp(car, collect);
        return ApiResult.ok(res);
    }


    @PostMapping(value = "/threePackageQueryById")
    @ApiOperation(value = "通过车架号查询三包信息")
    public ApiResult<CarMaintainCardVO> threePackageQueryById(@RequestBody CarMaintainCardParam car) {
        ApiResult<CarMaintainCardVO> query = maintainCardService.queryById(car.getVehicleNo());
        return query;
    }


    @PostMapping("del")
    @ApiOperation("删除-根据车架号删除该车辆下三包信息和所有绑定关系")
    public ApiResult<Boolean> del(@RequestBody List<String> vehicleNos) {
        // 当前登录人所属门店
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = repairOrderService.repairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        Boolean res = maintainCardService.delAllByVehicleNoApp(vehicleNos, collect);
        return ApiResult.ok(res);
    }

}
