package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Context:
 * @title: car_maintain_card
 * @Author： 郑杰
 * @Date: 2023/2/14 9:09
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "car_maintain_card", comment = "车辆三包信息")
@Table(name = "car_maintain_card")
@ApiModel(value = "车辆三包信息",description = "车辆三包信息")
@Where(clause = "delete_flag = 0")
public class CarMaintainCardDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;
    
    @Column(name = "vehicle_no")
    private String vehicleNo;
    
    @Column(name = "car_name")
    private String carName;
    
    @Column(name = "vehicle_type")
    private String vehicleType;
    
    @Column(name = "purchase_time")
    private LocalDate purchaseTime;
    
    @Column(name = "car_owner_id")
    private long carOwnerId;

    @ApiModelProperty("车辆规格")
    @Column(name = "vehicle_specs", columnDefinition = "varchar(255) comment '车辆规格'")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    @Column(name = "vehicle_color", columnDefinition = "varchar(50) comment '车辆颜色'")
    private String vehicleColor;



    @ApiModelProperty("车主身份证号")
    @Column(name = "user_idcard", columnDefinition = "varchar(30) comment '车主身份证号'")
    private String userIdCard;

    @ApiModelProperty("车主性别")
    @Column(name = "user_sex", columnDefinition = "varchar(1) comment '车主性别'")
    private String userSex;

    @ApiModelProperty("车主地区")
    @Column(name = "user_area", columnDefinition = "varchar(400) comment '车主地区'")
    private String userArea;

    @ApiModelProperty("车主生日")
    @Column(name = "user_birthday", columnDefinition = "datetime default null comment '车主生日'")
    private LocalDate userBirthday;

    @ApiModelProperty("购买金额")
    @Column(name = "vehicle_buy_price", columnDefinition = "decimal(10,2) comment '购买金额'")
    private BigDecimal vehicleBuyPrice;


    @ApiModelProperty("车辆来源")
    @Column(name = "vehicle_source", columnDefinition = "int(1) comment '车辆来源 1-立马 0-非立马'")
    private Integer vehicleSource;


    @ApiModelProperty("销售门店ID")
    @Column(name = "sales_outlets_id", columnDefinition = "bigint(20) comment '销售门店ID'")
    private Long salesOutletsId;

    @ApiModelProperty("销售门店名称")
    @Column(name = "sales_outlets_name", columnDefinition = "varchar(100) comment '销售门店名称'")
    private String salesOutletsName;

    @ApiModelProperty("销售门店编码")
    @Column(name = "sales_outlets_code", columnDefinition = "varchar(50) comment '销售门店编码'")
    private String salesOutletsCode;

    @Column(name = "source_platform", columnDefinition = "varchar(50) comment '来源平台'")
    private String sourcePlatform;
    @Column(name = "cust_name", columnDefinition = "varchar(50) comment '所属经销商'")
    private String custName;
    @Column(name = "region", columnDefinition = "varchar(50) comment '所属区域'")
    private String region;
    @Column(name = "cust_code2", columnDefinition = "varchar(50) comment '客户号'")
    private String custCode2;
}
