package com.elitesland.yst.production.aftersale.out.support;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@AllArgsConstructor
@Slf4j
public class OrgAddrRpcServiceImpl implements OrgAddrService{
    private final OrgAddrRpcService orgAddrRpcService;

    @Override
    public List<OrgAddressRpcDTO> findAddrAddressRpcDtoByParam(OrgAddressRpcDtoParam param) {
        log.info("orgStoreGet：{}"+ JSON.toJSONString(param));
        try {
            List<OrgAddressRpcDTO> OrgAddressRpcDTOS = orgAddrRpcService.findAddrAddressRpcDtoByParam(param);
            return OrgAddressRpcDTOS;
        } catch (Exception e) {
            log.error("orgStoreGet error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询门店地址信息失败"+e.getMessage());
        }
    }
}
