package com.elitesland.yst.production.aftersale.service;

import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.vo.AddressInfoVo;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * @author Danny.Wang
 * @title CarOwnerVehicleService
 * @Date2023/2/8 15:18
 */
public interface CarOwnerVehicleService {

    /**
     * 保存绑定车辆信息
     *
     * @param carOwnerVehicleParam
     * @return
     */
    ApiResult<Object> bindVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam);

    /**
     * 解除绑定车辆信息
     *
     * @param id
     * @return
     */
    ApiResult<Object> deleteBindVehicle(Long id);


    /**
     * 解除绑定车辆信息并删除三包信息
     *
     * @param id
     * @return
     */
    ApiResult<Object> deleteBindVehicleAndThreePack(Long id);

    /**
     * 车主绑定车辆查询
     *
     * @return
     */
    ApiResult<Object> bindVehicleQuery();

    /**
     * 车主信息管理 - 关联车辆查询
     *
     * @param carOwnerId
     * @return
     */
    List<CarOwnerVehicleInfoVO> bindVehicleMngQuery(Long carOwnerId);

    /**
     * 售出车辆绑定 - 分页查询
     *
     * @param param
     * @return
     */
    PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery(BindSoldVehicleParam param);

    /**
     * 售出车辆绑定 - 分页查询
     *
     * @param param
     * @return
     */
    PagingVO<BindSoldVehicleVO> bcBindSoldVehicleQuery(BindSoldVehicleParam param);

    /**
     * 售出车辆绑定 - 明细查询
     *
     * @param id
     * @return
     */
    CarOwnerVehicleInfoVO bindSoldVehicleDetail(Long id);

    /**
     * 售出车辆绑定 - 信息保存
     *
     * @param carOwnerVehicleParam
     * @return
     */
    ApiResult<Long> bindSoldVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform);

    /**
     * 经销商PC - 解除绑定车辆信息
     *
     * @param userPhone
     * @param userName
     * @return
     */
    ApiResult<Object> deleteBindVehicleToFront(String userPhone, String userName, Long vehicleInfoId);

    /**
     * 车辆绑定信息管理 - 分页查询
     *
     * @param param
     * @return
     */
    PagingVO<BindSoldVehicleVO> vehicleBindInfoQuery(BindSoldVehicleParam param);


    /**
     * 通过身份证号码获取车主地址、生日、性别信息
     *
     * @param userCardId
     * @return
     */
    AddressInfoVo queryByUserCardId(String userCardId);

    /**
     * 通过上传的身份证调用阿里云识别身份信息
     *
     * @param file
     * @return
     */
    RecognizeIdcardResponse ocrScan(MultipartFile file);

    ApiResult<Object> custDateRepair(BindSoldVehicleParam param);

    /**
     * 根据手机号更新姓名
     *
     * @param carOwnerInfoDO
     */
    void updateCarowner(CarOwnerInfoDO carOwnerInfoDO);

    /**
     * 根据手机号 查询已绑定的车辆信息
     *
     * @param phone
     * @return
     */
    List<CarOwnerVehicleInfoVO> findCarByUserPhone(String phone);

    /**
     * 根据车架号 查询已绑定的车辆信息
     *
     * @param vehicleNoList
     * @return
     */
    List<BindSoldVehicleVO> findCustByVehicleNo(List<String> vehicleNoList);

    /**
     * 根据用户和车架号查询绑车表是否存在
     *
     * @param userPhone
     * @param vehicleNo
     * @return
     */
    Boolean existBy(String userPhone, String vehicleNo);

    /**
     * 根据用户手机号和身份证查询绑车表是否存在
     *
     * @param userPhone
     * @param userCardId
     * @return
     */
    Boolean existByPhoneAId(String userPhone, String userCardId);

    /**
     * genxin
     *
     * @param userPhone
     * @param vehicleNo
     * @param b
     */
    void updateActivatFlag(String userPhone, String vehicleNo, boolean b);

    /**
     * 根据车架号获取
     *
     * @param vehicleNo
     */
    CarOwnerVehicleInfoVO getByVerNo(String vehicleNo);

    /**
     * 车辆绑定信息管理分页查询(业务)
     * @param param
     * @return
     */
    PagingVO<BindSoldVehicleVO> vehicleBindInfoQuerySaleMan(BindSoldVehicleParam param);



    /**
     * 根据手机号分页查询绑车数据
     * @param bindSoldVehicleParam
     * @return
     */
    PagingVO<CarOwnerVehicleInfoVO> queryPageByPhone(CarOwnerVehiclePhonePageParam bindSoldVehicleParam);

    Integer getUserFlmVehicleBindQty();
}
