package com.elitesland.yst.production.aftersale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderCancelParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;

import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
public interface ComplaintOrderService {
    /**
     * 客诉工单保存
     * @param saveVO
     * @return  客诉工单id
     */
    Long save(com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO);

    /**
     * 客诉工单批量取消
     * @param ids
     * @return
     */
    void complaintOrderBatchCancel(List<Long> ids);

    /**
     * 客诉工单取消
     * @param param
     * @return
     */
    void complaintOrderCancel(ComplaintOrderCancelParam param);

    /**
     * 客诉工单删除
     * @param ids
     * @return
     */
    void complaintOrderDelete(List<Long> ids);

    /**
     * 客诉工单分页查询
     * @param param
     * @return  查询结果
     */
    PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param);

    /**
     * 客诉工单详细信息查询
     * @param param
     * @return 客诉工单详细信息
     */
    ComplaintOrderVO queryInfo(ComplaintOrderPageParam param);

    /**
     * 客诉工单详细信息导出
     * @param repairOrderExlParam
     * @return 导出内容
     */
    PagingVO<ComplaintOrderVO> export(ComplaintOrderExlParam repairOrderExlParam);

    /**
     * 客诉工单派单
     * @param saveVO
     */
    void complaintOrderDispatch(ComplaintOrderParam saveVO);

    /**
     * 客诉工单解决
     * @param saveVO
     */
    void complaintOrderComplete(ComplaintOrderParam saveVO);

    /**
     * 客诉工单超时评价任务
     */
    void complaintOrderJob();

    /**
     * 维修工单超时评价任务
     */
    void repairOrderJob();

    /**
     * 响应超时任务
     */
    void respTimeOutJob();

    /**
     * 处理超时任务
     */
    void handleTimeOutJob();
}
