package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.model.entity.BatteryGuaranteesDO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.MaintainCardInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnverCardUpdParam;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardInfoVo;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardTotalVo;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryGuaranteesVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryQueryVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.provider.sale.SalesmanRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.ItmWarrantyConfigRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.repo.BatteryGuaranteesRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.BatteryRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.MaintainCardInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.MaintainCardInfoRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmSaleDoRpcService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.yst.production.support.provider.price.dto.ItmWarrantyConfigRpcDTO;
import com.elitesland.yst.production.support.provider.price.param.ItmWarrantyConfigRpcQueryParam;
import com.elitesland.yst.production.support.provider.price.service.ItmWarrantyConfigRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Context:
 * @title: ThreePackageServiceImpl
 * @Author： 郑杰
 * @Date: 2023/2/14 16:45
 */
@Service
@Log4j2
public class MaintainCardServiceImpl extends BaseServiceImpl implements MaintainCardService {

    @Autowired
    private CarService carService;

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;

    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;

    @Autowired
    private MaintainCardInfoRepo maintainCardInfoRepo;

    @Autowired
    private MaintainCardInfoRepoProc maintainCardInfoRepoProc;

    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;

    @Autowired
    private CarMaintainCardRepoProc carMaintainCardRepoProc;

    @Autowired
    private BatteryGuaranteesRepoProc batteryGuaranteesRepoProc;

    @Autowired
    private PictureOrderService pictureOrderService;

    @Autowired
    private CarOwnerInfoRepo carOwnerInfoRepo;
    @Value("${file.upload.url}")
    private String pictureURL;


    // @Autowired
    // private ItmWarrantyConfigRpcService itmWarrantyConfigRpcService;

    @Autowired
    private ItmWarrantyConfigRpcProvider itmWarrantyConfigRpcProvider;

    @Autowired
    private CarOwnerVehicleRelateRepoProc carOwnerVehicleRelateRepoProc;

    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;

    @Autowired
    private EmployeeRpcService employeeRpcService;

    @Autowired
    private UserService userService;

    @Autowired
    private CrmSaleService crmSaleService;
    @Autowired
    private SalesmanRpcProvider salesmanRpcProvider;
    @Autowired
    private UdcProvider udcProvider;
    private static final String YST_SUPPORT = "yst-supp";
    private static final String REGION = "REGION";

    private static final String ACTIVE_THREE_PACKAGE_LOCK = "ACTIVE_THREE_PACKAGE_LOCK";

    private static final String ACTIVE_THREE_PACKAGE = "ACTIVE_THREE_PACKAGE";

    @Autowired
    private PictureOrderRepo pictureOrderRepo;

    @Autowired
    private SysMsgRpcProvider sysMsgRpcProvider;

    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    @Autowired
    private CrmCustAccountRpcService crmCustAccountRpcService;

    @Autowired
    private BatteryRepoProc batteryRepoProc;

    @Autowired
    private ItmWarrantyConfigRpcService itmWarrantyConfigRpcService;

    @Autowired
    private LmSaleDoRpcService lmSaleDoRpcService;

    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> activate(CarMaintainCardParam carMaintainCardParam) {
        CarOwnerInfoDO byCarOwnerId = carOwnerInfoRepo.findByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (null == byCarOwnerId) {
            throw new BusinessException("未找到车主信息，请检查是否有误");
        }
        if (carMaintainCardRepo.countByVehicleNoAndDeleteFlag(carMaintainCardParam.getVehicleNo(), 0) > 0) {
            throw new BusinessException(ApiCode.FAIL, "该车辆已激活");

        } else {
            List<String> vehicleNoList = new ArrayList<>();
            vehicleNoList.add(carMaintainCardParam.getVehicleNo());
            CarMaintainCardDO cardDO = carMaintainCardRepo.findByVehicleNoAndDeleteFlag(carMaintainCardParam.getVehicleNo(), 1);
            SalemanCustDTO salemanCust = salesmanRpcProvider.getSalemanCust(carMaintainCardParam.getSalesOutletsId()).getData();

            if(null != salemanCust) {
                var custCodeList = lmSaleDoRpcService.vehicleBelongCustList(carMaintainCardParam.getVehicleNo());
                if (CollectionUtils.isEmpty(custCodeList)) {
                    if (null != carMaintainCardParam.getManufactureDate() &&
                            carMaintainCardParam.getManufactureDate().isAfter(LocalDateTime.of(2023, 1, 1, 0, 0))) {
                        throw new BusinessException("车架号" + carMaintainCardParam.getVehicleNo() + "不属于当前经销商" + salemanCust.getCustCode() + ",请联系业务主管");
                    }
                } else {
                    String joinStr = custCodeList.stream().collect(Collectors.joining("','"));
                    String sql2 = "select relate_cust_code from lm_cust_relate where cust_code in ('" + joinStr + "')";
                    var result = jdbcTemplate.queryForList(sql2, String.class);
                    if(!org.springframework.util.CollectionUtils.isEmpty(result)) {
                        custCodeList.addAll(result);
                    }
                    if(StringUtils.isNotEmpty(salemanCust.getPid())){
                        if(!(custCodeList.contains(salemanCust.getCustCode()) || custCodeList.contains(salemanCust.getPid()))){
                            throw new BusinessException("车架号" + carMaintainCardParam.getVehicleNo() + "不属于当前经销商" + salemanCust.getCustCode() + ",请联系业务主管");
                        }
                    }else {
                        if(!custCodeList.contains(salemanCust.getCustCode())){
                            throw new BusinessException("车架号" + carMaintainCardParam.getVehicleNo() + "不属于当前经销商" + salemanCust.getCustCode() + ",请联系业务主管");
                        }
                    }
                }
            }

//            List<BindSoldVehicleVO> bindSoldVehicleVOList = carOwnerVehicleService.findCustByVehicleNo(vehicleNoList);
            if (cardDO != null) {
                // 车架号对应的删除标志是 1 【已删除】，将车主id改为传入的车主id，购买时间也改为传入的购买时间，删除标志改为 0【未删除】
                cardDO.setCarOwnerId(carMaintainCardParam.getCarOwnerId());
                cardDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
                cardDO.setDeleteFlag(0);
                cardDO.setSalesOutletsId(carMaintainCardParam.getSalesOutletsId());
                cardDO.setSalesOutletsCode(carMaintainCardParam.getSalesOutletsCode());
                cardDO.setSalesOutletsName(carMaintainCardParam.getSalesOutletsName());
                cardDO.setVehicleBuyPrice(carMaintainCardParam.getVehicleBuyPrice());
                cardDO.setUserIdCard(carMaintainCardParam.getUserIdCard());
                cardDO.setUserArea(carMaintainCardParam.getUserArea());
                cardDO.setUserSex(carMaintainCardParam.getUserSex());
                cardDO.setUserBirthday(carMaintainCardParam.getUserBirthday());
                cardDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
                cardDO.setCreateTime(LocalDateTime.now());
                if (null != salemanCust) {
                    cardDO.setRegion(salemanCust.getRegion());
                    cardDO.setCustCode2(salemanCust.getCustCode2());
                    cardDO.setCustName(salemanCust.getCustName());
                }

                // 根据车架号修改激活时间
                carOwnerVehicleRepoProc.updateActivatFlag(byCarOwnerId.getUserPhone(), carMaintainCardParam.getVehicleNo(), true);

                CarMaintainCardDO save = carMaintainCardRepo.save(cardDO);
                if(!CollectionUtils.isEmpty(carMaintainCardParam.getPictureOrderParamList())){
                    List<PictureOrderDO> pictureOrderDOList=new ArrayList<>();
                    carMaintainCardParam.getPictureOrderParamList().forEach(vo->{
                        PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO(vo);
                        pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
                        pictureOrderDO.setOrderId(save.getId());
                        pictureOrderDOList.add(pictureOrderDO);
                    });
                    pictureOrderRepo.saveAll(pictureOrderDOList);
                }
                // 若没有三包配置信息，则新增
                List<MaintainCardInfoDO> byVehicleThreePackNo = maintainCardInfoRepo.findByVehicleThreePackNo(cardDO.getId());
                if (null == byVehicleThreePackNo || CollectionUtils.isEmpty(byVehicleThreePackNo)) {
                    ItmWarrantyConfigRpcQueryParam param = new ItmWarrantyConfigRpcQueryParam();
                    param.setItemGroup2(carMaintainCardParam.getItemGroup2());
                    param.setSpuCode(carMaintainCardParam.getSpuCode());
                    List<ItmWarrantyConfigRpcDTO> config = getConfig(param);
                    config.forEach(s -> {
                        String name = "";
                        MaintainCardInfoDO maintainCardInfoDO = new MaintainCardInfoDO();

                        if (!StringUtils.isEmpty(s.getItemType3Name())) {
                            name = s.getItemType3Name();
                        }
                        if (!StringUtils.isEmpty(s.getItemName2())) {
                            name = name.equals("") ? s.getItemName2() : s.getItemName2() + "/" + name;
                        }
                        if (!StringUtils.isEmpty(s.getItemName())) {
                            name = name.equals("") ? s.getItemName() : s.getItemName() + "/" + name;
                        }
                        maintainCardInfoDO.setMountingsName(name);
                        maintainCardInfoDO.setVehicleThreePackNo(cardDO.getId());//获取车辆三包信息表的id
                        maintainCardInfoDO.setConfigId(s.getId()); // 配件id
                        //maintainCardInfoDO.setMountingsName(s.getItemName());
                        maintainCardInfoDO.setMaintainTime(s.getConsumerWarrantyTime().doubleValue());
                        maintainCardInfoDO.setConsumerWarrantyTimeUom(s.getConsumerWarrantyTimeUom());
                        maintainCardInfoDO.setContainThreePack(s.getWarrantyContent());
                        maintainCardInfoDO.setNotContainThreePack(s.getWarrantyExcluded());
                        maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getPurchaseTime());
                        maintainCardInfoDO.setRepairEndTime(getTime2(maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTime().doubleValue(), maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTimeUom()));
                        maintainCardInfoRepo.save(maintainCardInfoDO);
                    });

                }

            } else {

                // 0707 新增校验： 一个车主id仅能激活3辆 立马车
                int carCount = carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
                if (carCount > 2) {
                    throw new BusinessException("激活失败,一个会员最多只能激活3台车，现已激活数量:" + carCount);
                }

                //log.info("车辆三包激活入参{}", carMaintainCardParam);
                // 根据车架号从车辆信息表中查询车型，车辆名称[直接调用carservice的方法]
                CarParam carParam = new CarParam();
                carParam.setVehicleNo(carMaintainCardParam.getVehicleNo());
//                ApiResult<List<CarVO>> query = carService.queryList(carParam);
//                CarVO carVO = query.getData().get(0);
                // 赋值给VehicleThreePackageDO对象，然后存入车辆三包信息表中
                CarMaintainCardDO vDO = new CarMaintainCardDO();
                vDO.setVehicleNo(carMaintainCardParam.getVehicleNo());
//                vDO.setCarName(carVO.getVehicleName());
                vDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
                vDO.setCarOwnerId(carMaintainCardParam.getCarOwnerId());
                vDO.setVehicleColor(carMaintainCardParam.getVehicleColor());
                vDO.setVehicleSpecs(carMaintainCardParam.getVehicleSpecs());
                vDO.setVehicleType(carMaintainCardParam.getVehicleType());

                vDO.setVehicleSource(carMaintainCardParam.getVehicleSource());
                vDO.setVehicleBuyPrice(carMaintainCardParam.getVehicleBuyPrice());
                vDO.setUserIdCard(carMaintainCardParam.getUserIdCard());
                vDO.setUserArea(carMaintainCardParam.getUserArea());
                vDO.setUserSex(carMaintainCardParam.getUserSex());
                vDO.setUserBirthday(carMaintainCardParam.getUserBirthday());
                vDO.setSourcePlatform(carMaintainCardParam.getSourcePlatform());
                vDO.setSalesOutletsId(carMaintainCardParam.getSalesOutletsId());
                vDO.setSalesOutletsCode(carMaintainCardParam.getSalesOutletsCode());
                vDO.setSalesOutletsName(carMaintainCardParam.getSalesOutletsName());
                if (null != salemanCust) {
                    vDO.setRegion(salemanCust.getRegion());
                    vDO.setCustCode2(salemanCust.getCustCode2());
                    vDO.setCustName(salemanCust.getCustName());
                }
                CarMaintainCardDO save = carMaintainCardRepo.save(vDO);
                if(!CollectionUtils.isEmpty(carMaintainCardParam.getPictureOrderParamList())){
                    List<PictureOrderDO> pictureOrderDOList=new ArrayList<>();
                    carMaintainCardParam.getPictureOrderParamList().forEach(vo->{
                        PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO(vo);
                        pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
                        pictureOrderDO.setOrderId(save.getId());
                        pictureOrderDOList.add(pictureOrderDO);
                    });
                    pictureOrderRepo.saveAll(pictureOrderDOList);
                }

                // 将数据保存到车辆配件三包信息表中
                Long id = carMaintainCardRepo.findByVehicleNo(carMaintainCardParam.getVehicleNo()).getId();
//                try {
                ItmWarrantyConfigRpcQueryParam param = new ItmWarrantyConfigRpcQueryParam();
                param.setItemGroup2(carMaintainCardParam.getItemGroup2());
                param.setSpuCode(carMaintainCardParam.getSpuCode());
                List<ItmWarrantyConfigRpcDTO> config = getConfig(param);
                config.forEach(s -> {
                    String name = "";
                    MaintainCardInfoDO maintainCardInfoDO = new MaintainCardInfoDO();

                    if (!StringUtils.isEmpty(s.getItemType3Name())) {
                        name = s.getItemType3Name();
                    }
                    if (!StringUtils.isEmpty(s.getItemName2())) {
                        name = name.equals("") ? s.getItemName2() : s.getItemName2() + "/" + name;
                    }
                    if (!StringUtils.isEmpty(s.getItemName())) {
                        name = name.equals("") ? s.getItemName() : s.getItemName() + "/" + name;
                    }
                    maintainCardInfoDO.setMountingsName(name);
                    maintainCardInfoDO.setVehicleThreePackNo(id);//获取车辆三包信息表的id
                    maintainCardInfoDO.setConfigId(s.getId()); // 配件id
                    //maintainCardInfoDO.setMountingsName(s.getItemName());
                    maintainCardInfoDO.setMaintainTime(s.getConsumerWarrantyTime().doubleValue());
                    maintainCardInfoDO.setConsumerWarrantyTimeUom(s.getConsumerWarrantyTimeUom());
                    maintainCardInfoDO.setContainThreePack(s.getWarrantyContent());
                    maintainCardInfoDO.setNotContainThreePack(s.getWarrantyExcluded());
//                        if (carMaintainCardParam.getProductionDate() != null && carMaintainCardParam.getProductionDate().isBefore(LocalDate.of(2023, 1, 1))) {
//                            maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getProductionDate());
//                        } else {
//                            maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getPurchaseTime());
//                        }
                    maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getPurchaseTime());
                    maintainCardInfoDO.setRepairEndTime(getTime2(maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTime().doubleValue(), maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTimeUom()));
                    //log.info("开始时间是：{}，到期时间是：{}",getTime(carMaintainCardParam.getPurchaseTime(),s.getConsumerWarrantyTime().doubleValue()));
                    maintainCardInfoRepo.save(maintainCardInfoDO);
                });

//                } catch (Exception e) {
//                    throw new BusinessException(ApiCode.FAIL, "系统繁忙，请稍后重试【BK001】" + e);
//                }


            }

        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> query(Long carOwnerId, int page, int pageSize) {

        Pageable pageable = PageRequest.of(page - 1, pageSize);
        log.info(pageable);

        List<CarOwnerMaintainCardVO> CMCRS = new ArrayList<>();
        int total = carMaintainCardRepo.countByCarOwnerId(carOwnerId);
        List<CarMaintainCardDO> carMaintainCardDOS = carMaintainCardRepo.findByCarOwnerIdAndDeleteFlag(carOwnerId, pageable, 0);
        if (carMaintainCardDOS != null) {
            carMaintainCardDOS.stream().forEach(s -> {
                CarOwnerMaintainCardVO carMaintainCardRespVO = new CarOwnerMaintainCardVO();
                carMaintainCardRespVO.setCarName(s.getCarName());
                carMaintainCardRespVO.setVehicleSpecs(s.getVehicleSpecs());
                carMaintainCardRespVO.setVehicleColor(s.getVehicleColor());
                carMaintainCardRespVO.setVehicleNo(s.getVehicleNo());
                carMaintainCardRespVO.setMaintainCardInfoS(maintainCardInfoRepo.findByVehicleThreePackNo(s.getId()));
                carMaintainCardRespVO.setVehicleType(s.getVehicleType());
                CMCRS.add(carMaintainCardRespVO);
            });
            CarMaintainCardTotalVo totalVo = new CarMaintainCardTotalVo();
            totalVo.setTotal(total);
            totalVo.setCmcrs(CMCRS);
            return ApiResult.ok(totalVo);
        }
        return ApiResult.fail("未绑定立马车辆！");
    }

    @Override
    public ApiResult<CarMaintainCardVO> queryById(String vehicleNo) {
        CarMaintainCardVO carMaintainCardVO = new CarMaintainCardVO();
        CarMaintainCardDO carMaintainCardDO = carMaintainCardRepo.findByVehicleNoAndDeleteFlag(vehicleNo, 0);
        if (carMaintainCardRepo.countByVehicleNo(vehicleNo) == 0) {
            return ApiResult.ok(null);
        }


        ArrayList<CarMaintainCardInfoVo> list = new ArrayList<>();

        List<MaintainCardInfoDO> maintainCardInfoDOS = maintainCardInfoRepo.findByVehicleThreePackNo(carMaintainCardDO.getId());
        maintainCardInfoDOS.stream().forEach(s -> {
            CarMaintainCardInfoVo carMaintainCardInfoVo = new CarMaintainCardInfoVo();
            carMaintainCardInfoVo.setMountingsName(s.getMountingsName());
            carMaintainCardInfoVo.setRepairStartTime(s.getRepairStartTime());
            carMaintainCardInfoVo.setVehicleThreePackNo(s.getVehicleThreePackNo());
            carMaintainCardInfoVo.setContainThreePack(s.getContainThreePack());
            carMaintainCardInfoVo.setNotContainThreePack(s.getNotContainThreePack());
            carMaintainCardInfoVo.setRemark(s.getRemark());
            carMaintainCardInfoVo.setConfigId(s.getConfigId());
            Double d = new Double(s.getMaintainTime());
            if (99 == d.intValue() && "Y".equals(s.getConsumerWarrantyTimeUom())) {
                carMaintainCardInfoVo.setMaintainTime(null);
                carMaintainCardInfoVo.setConsumerUom("终身");
                carMaintainCardInfoVo.setRepairEndTime(null);
            } else {
                carMaintainCardInfoVo.setMaintainTime(s.getMaintainTime());
                carMaintainCardInfoVo.setConsumerUom(s.getConsumerWarrantyTimeUom());
                carMaintainCardInfoVo.setRepairEndTime(s.getRepairEndTime());
            }
            list.add(carMaintainCardInfoVo);
        });
        carMaintainCardVO.setCarName(carMaintainCardDO.getCarName());
        carMaintainCardVO.setPurchaseTime(carMaintainCardDO.getPurchaseTime());
        carMaintainCardVO.setVehicleType(carMaintainCardDO.getVehicleType());
        carMaintainCardVO.setVehicleSpecs(carMaintainCardDO.getVehicleSpecs());
        carMaintainCardVO.setVehicleColor(carMaintainCardDO.getVehicleColor());
        carMaintainCardVO.setMaintainCardInfoS(list);

        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(List.of(carMaintainCardDO.getId()));
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        if(!CollectionUtils.isEmpty(data)){
            for (PictureOrderVO pictureOrderVO : data) {
                if(!pictureOrderVO.getUrl().startsWith("http")){
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                }else{
                    pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
                }
            }
        }
        carMaintainCardVO.setImgs(data);

//        try {
//            // 保卡添加 三包内容、非三包内容、备注
//            CarParam carParam = new CarParam();
//            carParam.setVehicleNo(vehicleNo);
//            ApiResult<CarVO> carInfo = carService.query(carParam);
//            ItmWarrantyConfigRpcQueryParam itmWarrantyConfigRpcQueryParam = new ItmWarrantyConfigRpcQueryParam();
//            itmWarrantyConfigRpcQueryParam.setItemCodes(Collections.singletonList(Objects.requireNonNull(carInfo.getData()).getMtnrv()));
//
//            List<ItmWarrantyConfigRpcDTO> config = itmWarrantyConfigRpcService.getConfig(itmWarrantyConfigRpcQueryParam);
//            if(!config.isEmpty()){
//                ItmWarrantyConfigRpcDTO itmWarrantyConfigRpcDTO = config.get(0);
//                carMaintainCardVO.setWarrantyContent(itmWarrantyConfigRpcDTO.getWarrantyContent());
//                carMaintainCardVO.setWarrantyExcluded(itmWarrantyConfigRpcDTO.getWarrantyExcluded());
//                carMaintainCardVO.setRemark(itmWarrantyConfigRpcDTO.getRemark());
//            }
//        }catch (Exception e){
//            log.error("查询保卡配置项失败:{}", e.getMessage());
//        }

        return ApiResult.ok(carMaintainCardVO);
    }

    @Override
    public ApiResult delByVehicleNo(CarMaintainCardDO cardDO) {
        CarMaintainCardDO aDo = carMaintainCardRepo.findByVehicleNo(cardDO.getVehicleNo());
        if (aDo != null) {
            aDo.setDeleteFlag(1);
            carMaintainCardRepo.save(aDo);
            return ApiResult.ok();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean delMaintainCard(String vehicleNo) {

        CarMaintainCardDO aDo = carMaintainCardRepo.findByVehicleNo(vehicleNo);
        if (aDo != null) {
//            aDo.setDeleteFlag(1);
//            carMaintainCardRepo.save(aDo);
            carMaintainCardRepo.delMaintainCard(aDo.getId(),LocalDateTime.now());
            // 根据id删除三包配件内容信息
            maintainCardInfoRepoProc.delMaintainCard(aDo.getId());

        }
        return true;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean activateThreePackage2(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {
        carOwnerVehicleParam.setSourcePlatform(sourcePlatform);

        //获取车架号
        String vehicleNo = carOwnerVehicleParam.getVehicleNo();

        //模板车架号防重复激活
        RLock rLock = redissonClient.getLock(ACTIVE_THREE_PACKAGE_LOCK + vehicleNo);
        try {
            // 5秒内循环尝试获取锁，持有5分钟后⾃动过期，按业务需要调整数值，避免线程死锁
            if (!rLock.tryLock(5, 300, TimeUnit.SECONDS)) {
                throw new com.elitescloud.boot.exception.BusinessException("三包激活获取锁失败，请稍后重试");
            }
            String key = ACTIVE_THREE_PACKAGE + vehicleNo;
            //通过加锁来使这两步操作变为原子操作,使得每次只能有一个线程进行键值对设置
            if (redissonClient.getBucket(key).get() == null) {
                redissonClient.getBucket(key).set("1", 3, TimeUnit.SECONDS);
            } else {
                throw new BusinessException("相同时间内存在疑似重复三包激活");
            }
        }catch (com.elitescloud.boot.exception.BusinessException | InterruptedException e) {
            throw new com.elitescloud.boot.exception.BusinessException("三包激活失败,车架号" + vehicleNo + "异常原因:" + e);
        }finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }

        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();
        carMaintainCardParam.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carMaintainCardParam.setPurchaseTime(carOwnerVehicleParam.getPurchaseTime());
        carMaintainCardParam.setProductionDate(carOwnerVehicleParam.getProductionDate());
        carMaintainCardParam.setVehicleNo(carOwnerVehicleParam.getVehicleNo());
        carMaintainCardParam.setPictureOrderParamList(carOwnerVehicleParam.getPictureOrderParamList());
        carMaintainCardParam.setVehicleSource(carOwnerVehicleParam.getVehicleSource());
        carMaintainCardParam.setVehicleBuyPrice(carOwnerVehicleParam.getVehicleBuyPrice());
        carMaintainCardParam.setUserIdCard(carOwnerVehicleParam.getUserIdCard());
        carMaintainCardParam.setUserArea(carOwnerVehicleParam.getUserArea());
        carMaintainCardParam.setUserSex(carOwnerVehicleParam.getUserSex());
        carMaintainCardParam.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        carMaintainCardParam.setSourcePlatform(sourcePlatform);
        carMaintainCardParam.setVehicleType(carOwnerVehicleParam.getVehicleType());
        carMaintainCardParam.setSalesOutletsId(carOwnerVehicleParam.getSalesOutletsId());
        carMaintainCardParam.setSalesOutletsCode(carOwnerVehicleParam.getSalesOutletsCode());
        carMaintainCardParam.setSalesOutletsName(carOwnerVehicleParam.getSalesOutletsName());
        carMaintainCardParam.setVehicleColor(carOwnerVehicleParam.getVehicleColor());
        carMaintainCardParam.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
        carMaintainCardParam.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
        carMaintainCardParam.setSpuCode(carOwnerVehicleParam.getSpuCode());
        carMaintainCardParam.setManufactureDate(carOwnerVehicleParam.getManufactureDate());

        if(carOwnerVehicleParam.getUserIdCard() != null){
            int count = carMaintainCardRepoProc.existByPhoneAId(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getUserIdCard());
            if (count == 3) {
                throw new BusinessException("一个身份证只能激活三辆车,请勿重复激活");
            }
        }

        int carCount = carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (carCount == 3) {
            throw new BusinessException("一个手机号只能激活三辆车,请勿重复激活");
        }


        // 车辆激活
        ApiResult<Object> activate = this.activate(carMaintainCardParam);

        // 查询该用户该车架号是否绑定，如果没有绑定，进行绑定
        Boolean isExist = carOwnerVehicleService.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
        if (isExist) {
            carOwnerVehicleService.updateActivatFlag(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo(), true);
            return true;
        }
        // 车辆绑定
        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, sourcePlatform);
        if(CollectionUtils.isNotEmpty(carOwnerVehicleParam.getBatteryCodes())){
            bindBattery(carOwnerVehicleParam);
        }
        return true;
    }

    public boolean containsDuplicates(Collection<?> collection) {
        Set<?> set = new HashSet<>(collection);
        return set.size() < collection.size();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean activateThreePackage2Mn(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {

        if(null == carOwnerVehicleParam.getManufactureDate() || carOwnerVehicleParam.getManufactureDate().getYear() < 2023){
            throw new BusinessException("此车不可被车主自主激活，需联系经销商（门店）进行处理");

        }

        //获取车架号
        String vehicleNo = carOwnerVehicleParam.getVehicleNo();

        //模板车架号防重复激活
        RLock rLock = redissonClient.getLock(ACTIVE_THREE_PACKAGE_LOCK + vehicleNo);
        try {
            // 5秒内循环尝试获取锁，持有5分钟后⾃动过期，按业务需要调整数值，避免线程死锁
            if (!rLock.tryLock(5, 300, TimeUnit.SECONDS)) {
                throw new BusinessException("三包激活获取锁失败，请稍后重试");
            }
            String key = ACTIVE_THREE_PACKAGE + vehicleNo;
            //通过加锁来使这两步操作变为原子操作,使得每次只能有一个线程进行键值对设置
            if (redissonClient.getBucket(key).get() == null) {
                redissonClient.getBucket(key).set("1", 30, TimeUnit.SECONDS);
            } else {
                throw new BusinessException("相同时间内存在疑似重复三包激活");
            }
        }catch (BusinessException | InterruptedException e) {
            throw new BusinessException("三包激活失败,车架号" + vehicleNo + "异常原因:" + e);
        }finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }

        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();

        carMaintainCardParam.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carMaintainCardParam.setPurchaseTime(carOwnerVehicleParam.getPurchaseTime());
        carMaintainCardParam.setProductionDate(carOwnerVehicleParam.getProductionDate());
        carMaintainCardParam.setVehicleNo(carOwnerVehicleParam.getVehicleNo());

        carMaintainCardParam.setPictureOrderParamList(carOwnerVehicleParam.getPictureOrderParamList());
        carMaintainCardParam.setVehicleSource(carOwnerVehicleParam.getVehicleSource());
        carMaintainCardParam.setVehicleBuyPrice(carOwnerVehicleParam.getVehicleBuyPrice());
        carMaintainCardParam.setUserIdCard(carOwnerVehicleParam.getUserIdCard());
        carMaintainCardParam.setUserArea(carOwnerVehicleParam.getUserArea());
        carMaintainCardParam.setUserSex(carOwnerVehicleParam.getUserSex());
        carMaintainCardParam.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        carMaintainCardParam.setSourcePlatform(sourcePlatform);
        carMaintainCardParam.setVehicleType(carOwnerVehicleParam.getVehicleType());
        carMaintainCardParam.setSalesOutletsId(carOwnerVehicleParam.getSalesOutletsId());
        carMaintainCardParam.setSalesOutletsCode(carOwnerVehicleParam.getSalesOutletsCode());
        carMaintainCardParam.setSalesOutletsName(carOwnerVehicleParam.getSalesOutletsName());
        carMaintainCardParam.setVehicleColor(carOwnerVehicleParam.getVehicleColor());
        carMaintainCardParam.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
        carMaintainCardParam.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
        carMaintainCardParam.setSpuCode(carOwnerVehicleParam.getSpuCode());
        carMaintainCardParam.setManufactureDate(carOwnerVehicleParam.getManufactureDate());

        // 一个手机号+一个身份证，只能绑定一辆车
        if(carOwnerVehicleParam.getUserIdCard() != null){
            int count = carMaintainCardRepoProc.existByPhoneAId(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getUserIdCard());
            if (count == 3) {
                throw new BusinessException("一个身份证只能激活三辆车,请勿重复激活");
            }
        }

        int carCount = carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (carCount == 3) {
            throw new BusinessException("一个手机号只能激活三辆车,请勿重复激活");
        }

        // 车辆激活
        ApiResult<Object> activate = this.activate(carMaintainCardParam);

        // 查询该用户该车架号是否绑定，如果没有绑定，进行绑定
        Boolean isExist = carOwnerVehicleService.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
        if (isExist) {
            carOwnerVehicleService.updateActivatFlag(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo(), true);
            return true;
        }
        // 车辆绑定
        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, sourcePlatform);
        if(CollectionUtils.isNotEmpty(carOwnerVehicleParam.getBatteryCodes()) || CollectionUtils.isNotEmpty(carOwnerVehicleParam.getChargerCodes())){
            bindBattery(carOwnerVehicleParam);
        }

        try {
            sendActiveMsg(carOwnerVehicleParam);
        }catch (Exception e){
            log.error("激活消息发送失败，失败原因:{}", e.getMessage());
        }
        return true;

    }

    public void bindBattery(CarOwnerVehicleParam carOwnerVehicleParam){

        List<String> allCodes = new ArrayList<>();
        allCodes.addAll(carOwnerVehicleParam.getBatteryCodes());
        allCodes.addAll(carOwnerVehicleParam.getChargerCodes());

        if(containsDuplicates(allCodes)){
            throw new BusinessException("存在电池或电充编码重复，请检查录入的电池,电充信息");
        }

        List<BatteryQueryVO> list = batteryRepoProc.findBatteryCodes(allCodes);
        if(list.isEmpty() || list.size() < allCodes.size()){
            List<String> exitCodes = list.stream().map(BatteryQueryVO::getCode).collect(Collectors.toList());
            List<String> str =  allCodes.stream().filter(x -> !exitCodes.contains(x)).collect(Collectors.toList());
            throw new BusinessException(str + "未找到电池信息，请核对电池信息或联系业务员");
        }

        Map<String, String> typeMap = list.stream().collect(Collectors.toMap(BatteryQueryVO::getCode, BatteryQueryVO::getType));

        carOwnerVehicleParam.getBatteryCodes().forEach(code ->{
            String type = typeMap.get(code);
            if(!"电池".equals(type)){
                throw new BusinessException("编码为" + code + "的类型不是电池，请检查");
            }
            BatteryGuaranteesDO batteryGuaranteesDO = new BatteryGuaranteesDO();
            batteryGuaranteesDO.setIdCard(carOwnerVehicleParam.getUserIdCard());
            batteryGuaranteesDO.setCode(code);
            batteryGuaranteesDO.setType("电池");
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setOwnerMobile(carOwnerVehicleParam.getUserPhone());
            batteryGuaranteesDO.setOwnerName(carOwnerVehicleParam.getUserName());
            batteryGuaranteesDO.setGuaranteesTime(LocalDateTime.now());
            batteryGuaranteesDO.setVehicleType(carOwnerVehicleParam.getVehicleType());
            batteryGuaranteesDO.setSpuCode(carOwnerVehicleParam.getSpuCode());

            if(carOwnerVehicleParam.getSpuName() == null){
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getVehicleModel());
            }else {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getSpuName());
            }

            batteryGuaranteesDO.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());

            batteryGuaranteesDO.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
            batteryGuaranteesDO.setMtnrv(carOwnerVehicleParam.getMtnrv());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode()); // 经销商客户号
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName()); // 经销商名称
            batteryGuaranteesDO.setStoreCode(carOwnerVehicleParam.getSalesOutletsCode()); // 门店code
            batteryGuaranteesDO.setStoreName(carOwnerVehicleParam.getSalesOutletsName()); // 门店name
            batteryGuaranteesDO.setStoreId(String.valueOf(carOwnerVehicleParam.getSalesOutletsId())); // 门店id

            batteryGuaranteesDO.setProvince(carOwnerVehicleParam.getProvince()); // 省份
            batteryGuaranteesDO.setProvinceName(carOwnerVehicleParam.getProvinceName()); // 区域

            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setCustCode2(carOwnerVehicleParam.getCustCode2());
            batteryGuaranteesDO.setSaleRegion(carOwnerVehicleParam.getSaleRegion());
            batteryGuaranteesDO.setSaleRegionName(carOwnerVehicleParam.getSaleRegionName());

            batteryGuaranteesDO.setVehicleNo(carOwnerVehicleParam.getVehicleNo()); // 车架号
            batteryGuaranteesDO.setStoreCode2(carOwnerVehicleParam.getStoreCode2()); // 门店编码

            batteryGuaranteesRepoProc.save(batteryGuaranteesDO);
        });

        carOwnerVehicleParam.getChargerCodes().forEach(code ->{
            String type = typeMap.get(code);
            if(!"充电器".equals(type)){
                throw new BusinessException("编码为" + code + "的类型不是充电器，请检查");
            }
            BatteryGuaranteesDO batteryGuaranteesDO = new BatteryGuaranteesDO();
            batteryGuaranteesDO.setIdCard(carOwnerVehicleParam.getUserIdCard());
            batteryGuaranteesDO.setCode(code);
            batteryGuaranteesDO.setType("充电器");
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setOwnerMobile(carOwnerVehicleParam.getUserPhone());
            batteryGuaranteesDO.setOwnerName(carOwnerVehicleParam.getUserName());
            batteryGuaranteesDO.setGuaranteesTime(LocalDateTime.now());
            batteryGuaranteesDO.setVehicleType(carOwnerVehicleParam.getVehicleType());
            batteryGuaranteesDO.setSpuCode(carOwnerVehicleParam.getSpuCode());

            if(carOwnerVehicleParam.getSpuName() == null){
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getVehicleModel());
            }else {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getSpuName());
            }

            batteryGuaranteesDO.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());

            batteryGuaranteesDO.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
            batteryGuaranteesDO.setMtnrv(carOwnerVehicleParam.getMtnrv());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode()); // 经销商客户号
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName()); // 经销商名称
            batteryGuaranteesDO.setStoreCode(carOwnerVehicleParam.getSalesOutletsCode()); // 门店code
            batteryGuaranteesDO.setStoreName(carOwnerVehicleParam.getSalesOutletsName()); // 门店name
            batteryGuaranteesDO.setStoreId(String.valueOf(carOwnerVehicleParam.getSalesOutletsId())); // 门店id

            batteryGuaranteesDO.setProvince(carOwnerVehicleParam.getProvince()); // 省份
            batteryGuaranteesDO.setProvinceName(carOwnerVehicleParam.getProvinceName()); // 区域

            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setCustCode2(carOwnerVehicleParam.getCustCode2());
            batteryGuaranteesDO.setSaleRegion(carOwnerVehicleParam.getSaleRegion());
            batteryGuaranteesDO.setSaleRegionName(carOwnerVehicleParam.getSaleRegionName());

            batteryGuaranteesDO.setVehicleNo(carOwnerVehicleParam.getVehicleNo()); // 车架号
            batteryGuaranteesDO.setStoreCode2(carOwnerVehicleParam.getStoreCode2()); // 门店编码

            batteryGuaranteesRepoProc.save(batteryGuaranteesDO);
        });
    }



    @Override
    public void sendActiveMsg(CarOwnerVehicleParam param) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0005");
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("msgType", "");
            dto.setMesJoinParamMap(objectObjectHashMap);

            List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();

//            Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map = new HashMap<>();
//            map.put(MsgSendTypeEnum.SYS_INTERIOR,
//                    TemplateAssignRecipientUserAccountDTO.builder().account(param.getSalesOutletsCode()).build());
//            TemplateAssignRecipientUserDTO recipient = TemplateAssignRecipientUserDTO.builder()
//                    .recipientUserAccountDtoMap(map)
//                    .userName(param.getSalesOutletsCode())
//                    .build();
//            recipientUserList.add(recipient);


            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.getByCode(param.getSalesOutletsCode());
            if (null != orgStoreDetailRpcDTO) {
                List<String> codes = new ArrayList<>();
                codes.add(orgStoreDetailRpcDTO.getPcode());
                List<CustAccountVO> custAccountVOS = crmCustAccountRpcService.getCustAccountBycustCode(codes);
                if (!custAccountVOS.isEmpty()) {
                    CustAccountVO custAccountVO = custAccountVOS.get(0);
                    // 接收人
                    Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
                    map3.put(MsgSendTypeEnum.SYS_INTERIOR,
                            TemplateAssignRecipientUserAccountDTO.builder().account(custAccountVO.getMobile()).build());
                    TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder()
                            .recipientUserAccountDtoMap(map3)
                            .userName(custAccountVO.getUserName())
                            .build();
                    recipientUserList.add(recipient3);
                }
            }

            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("carUser", param.getUserName());
            interiorMap.put("vehicleType", param.getVehicleType());

            sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }


    @Override
    @SysCodeProc
    public PagingVO<CarMaintainCardVO> page(CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> page = carMaintainCardRepoProc.page(car);
        Map<String, String> regionMap = udcProvider.getValueMapByUdcCode(YST_SUPPORT, REGION);
        if(!CollectionUtils.isEmpty(page.getRecords())) {
            //判断是否购买保险
            page.getRecords().forEach(item -> {
                if(item.getPlanName()==null){
                    item.setIsSignedInsurance("否");
                }else{
                    item.setIsSignedInsurance("是");
                }
            });
            List<Long> ids = page.getRecords().stream().map(CarMaintainCardVO::getId).collect(Collectors.toList());
            PictureOrderParam pictureOrderParam = new PictureOrderParam();
            pictureOrderParam.setOrderList(ids);
            pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
            List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
            if(!CollectionUtils.isEmpty(data)){
                for (PictureOrderVO pictureOrderVO : data) {
                    if(!pictureOrderVO.getUrl().startsWith("http")){
                        pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                    }else{
                        pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
                    }
                }
            }
            Map<Long, List<PictureOrderVO>> collect = data.stream().collect(Collectors.groupingBy(PictureOrderVO::getOrderId));
            page.getRecords().stream().forEach(x ->{
                //图片数据
                if(!CollectionUtils.isEmpty(collect.get(x.getId()))){
                    x.setImgs(collect.get(x.getId()));
                }
                x.setSalesOutletsRegionName(regionMap.get(x.getRegion()));
            });

            List<String> vehicleList = page.getRecords().stream().map(CarMaintainCardVO::getVehicleNo).collect(Collectors.toList());

            var batteryMap =  carMaintainCardRepoProc.findBattery(vehicleList);
            var chargerMap = carMaintainCardRepoProc.findCharger(vehicleList);

            page.getRecords().forEach(x -> {
                x.setBatteryCodes(batteryMap.get(x.getVehicleNo()));
                x.setChargerCode(chargerMap.get(x.getVehicleNo()));
            });

        }

//        for (CarMaintainCardVO carMaintainCardVO : page.getRecords()) {
//            if (org.apache.commons.lang3.StringUtils.isBlank(carMaintainCardVO.getSalesOutletsName())) {
//                // 从绑车表获取
//                CarOwnerVehicleInfoVO byVerNo = carOwnerVehicleService.getByVerNo(carMaintainCardVO.getVehicleNo());
//                if (null != byVerNo) {
//                    carMaintainCardVO.setSalesOutletsName(byVerNo.getSalesOutletsName());
//                    carMaintainCardVO.setVehicleType(byVerNo.getVehicleType());
//                }
//
//            }
//
//        }
        return page;

    }

    private void fillCustInfo(List<CarMaintainCardVO> records) {
        List<String> vehicleNoList = records.stream().map(CarMaintainCardVO::getVehicleNo)
                .filter(org.apache.commons.lang3.StringUtils::isNotEmpty)
                .collect(Collectors.toList());

        List<BindSoldVehicleVO> bindSoldVehicleVOList = carOwnerVehicleService.findCustByVehicleNo(vehicleNoList);

        if(org.springframework.util.CollectionUtils.isEmpty(bindSoldVehicleVOList)){
            return;
        }
        List<Long> ids = records.stream().map(CarMaintainCardVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(ids);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        if(!CollectionUtils.isEmpty(data)){
            for (PictureOrderVO pictureOrderVO : data) {
                if(!pictureOrderVO.getUrl().startsWith("http")){
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                }else{
                    pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
                }
            }
        }
        Map<Long, List<PictureOrderVO>> collect = data.stream().collect(Collectors.groupingBy(PictureOrderVO::getOrderId));
        Map<String, List<BindSoldVehicleVO>> bindSoldVehicleVOMap = bindSoldVehicleVOList.stream().collect(Collectors.groupingBy(BindSoldVehicleVO::getVehicleNo));
        records.forEach(x ->{
            //图片数据
            if(!CollectionUtils.isEmpty(collect.get(x.getId()))){
                x.setImgs(collect.get(x.getId()));
            }
            if(bindSoldVehicleVOMap.containsKey(x.getVehicleNo())){
                List<BindSoldVehicleVO> bindSoldVehicleVOList1 = bindSoldVehicleVOMap.get(x.getVehicleNo());
                BindSoldVehicleVO bindSoldVehicleVO = bindSoldVehicleVOList1.stream()
                        .filter(s -> StringUtils.isEmpty(x.getSalesOutletsCode()) || s.getSalesOutletsCode().equals(x.getSalesOutletsCode()))
                        .findAny().orElse(null);
                if(null != bindSoldVehicleVO){
                    x.setCustCode2(bindSoldVehicleVO.getCustCode2());
                    x.setCustName(bindSoldVehicleVO.getCustName());
                    x.setSalesOutletsRegionName(bindSoldVehicleVO.getSalesOutletsRegionName());
                }
            }
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<CarMaintainCardVO> pageSaleMan(CarOwnerMaintainCardPageParam car) {
        ApiResult<SysEmployeeBasicDTO> result = employeeRpcService.getByUserId(userService.getUserId());
        if (result.getData() == null || org.apache.commons.lang3.StringUtils.isEmpty(result.getData().getCode())) {
            throw new BusinessException("当前用户获取员工code为空！！！");
        }

        if(!"SALESMAN".equals(result.getData().getType())){
            throw new BusinessException("当前登录人非业务员无法使用此页面");
        }
        String empCode = result.getData().getCode();
        List<Long> storeIdList = crmSaleService.querySaleManStoreIds(empCode);
        if (org.springframework.util.CollectionUtils.isEmpty(storeIdList)) {
            return PagingVO.<CarMaintainCardVO>builder()
                    .total(0)
                    .build();
        }
        car.setSalesOutletsIds2(storeIdList);
        PagingVO<CarMaintainCardVO> page = carMaintainCardRepoProc.page(car);
//        fillCustInfo(page.getRecords());
        Map<String, String> regionMap = udcProvider.getValueMapByUdcCode(YST_SUPPORT, REGION);
        if(!CollectionUtils.isEmpty(page.getRecords())) {
            page.getRecords().stream().forEach(x ->{
                x.setSalesOutletsRegionName(regionMap.get(x.getRegion()));
            });
        }
        return page;

    }

    @Override
    @SysCodeProc
    public CarMaintainCardVO get(Long id) {
        CarMaintainCardVO res = carMaintainCardRepoProc.get(id);
        if(res.getIsCancel() != null){
            res.setIsCancelStr(res.getIsCancel() == 0? "是": "否");
        }else{
            res.setIsCancelStr("否");
        }
        fillCustInfo(Lists.newArrayList(res));
        // 拼接三包配置
        List<CarMaintainCardInfoVo> resList = new ArrayList<>();
        List<MaintainCardInfoDO> byVehicleThreePackNo = maintainCardInfoRepo.findByVehicleThreePackNo(res.getId());
        for (MaintainCardInfoDO maintainCardInfoDO : byVehicleThreePackNo) {
            CarMaintainCardInfoVo cardInfoVo = new CarMaintainCardInfoVo();
            cardInfoVo.setId(maintainCardInfoDO.getId());
            cardInfoVo.setMountingsName(maintainCardInfoDO.getMountingsName());
            cardInfoVo.setMaintainTime(maintainCardInfoDO.getMaintainTime());
            cardInfoVo.setConsumerUom(maintainCardInfoDO.getConsumerWarrantyTimeUom());
            cardInfoVo.setRepairEndTime(maintainCardInfoDO.getRepairEndTime());
            cardInfoVo.setRepairStartTime(maintainCardInfoDO.getRepairStartTime());
            cardInfoVo.setVehicleThreePackNo(maintainCardInfoDO.getVehicleThreePackNo());
            cardInfoVo.setContainThreePack(maintainCardInfoDO.getContainThreePack());
            cardInfoVo.setNotContainThreePack(maintainCardInfoDO.getNotContainThreePack());
            cardInfoVo.setConfigId(maintainCardInfoDO.getConfigId());
            resList.add(cardInfoVo);

        }
        res.setMaintainCardInfoS(resList);
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(List.of(res.getId()));
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        if(!CollectionUtils.isEmpty(data)){
            for (PictureOrderVO pictureOrderVO : data) {
                if(!pictureOrderVO.getUrl().startsWith("http")){
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                }else{
                    pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
                }
            }
        }
        res.setImgs(data);
        return res;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean delAllByVehicleNo(List<String> vehicleNos) {

        log.info("车辆三包删除入参 vehicleNos:{}", vehicleNos.toString());

        for (String vehicleNo : vehicleNos) {
            // 删除绑定信息
            carOwnerVehicleRepoProc.deletearOwnerVehicleInfoByNo(vehicleNo);
            log.info("车辆解除绑定成功车架号: {}", vehicleNo);
            // 删除绑定关系表
            List<Long> byNos = carOwnerVehicleRepoProc.getByNo(vehicleNo);
            carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateByVids(byNos);
            log.info("车主与车辆关系表删除成功 {}", byNos);
            // 删除三包信息
            this.delMaintainCard(vehicleNo);
            log.info("三包信息表删除成功：车架号: {}", vehicleNo);

        }

        //删除电池激活信息
//        delBatteryGuaranteesByVehicleNo(vehicleNos);
        return true;
    }


    public void delBatteryGuaranteesByVehicleNo(List<String> vehicleNos){
        List<BatteryGuaranteesVO> list = batteryGuaranteesRepoProc.findByVehicleNo(vehicleNos);
        List<String> codes = list.stream().map(
                it -> "battery" + it.getCode()
        ).collect(Collectors.toList());
        if(!list.isEmpty()){
            //删除电池激活列表 删除redis缓存
            batteryGuaranteesRepoProc.deletearBatteryGuaranteesByVehicleNo(vehicleNos);
            log.info("电池激活表删除成功，车架号: {}", vehicleNos);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean delAllByVehicleNoApp(List<String> vehicleNos, List<Long> sids) {

        log.info("车辆三包删除入参 vehicleNos:{}", vehicleNos.toString());
        log.info("车辆三包销售门店ids入参 sids:{}", sids.toString());

        if (CollectionUtils.isEmpty(vehicleNos)) {
            throw new BusinessException("进行三包解绑时，车架号不能为空");
        }
        if (CollectionUtils.isEmpty(sids)) {
            return true;
        }
        // 根据门店id查询所在的车架号
        List<String> vNoList = carOwnerVehicleRepoProc.findBySaleOutsIds(sids);
        if (CollectionUtils.isEmpty(vNoList)) {
            return true;
        }

        for (String vehicleNo : vehicleNos) {
            if (vNoList.contains(vehicleNo)) {
                // 删除绑定信息
                carOwnerVehicleRepoProc.deletearOwnerVehicleInfoByNo(vehicleNo);
                log.info("车辆解除绑定成功车架号: {}", vehicleNo);
                // 删除绑定关系表
                List<Long> byNos = carOwnerVehicleRepoProc.getByNo(vehicleNo);
                carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateByVids(byNos);
                log.info("车主与车辆关系表删除成功 {}", byNos);
                // 删除三包信息
                this.delMaintainCard(vehicleNo);
                log.info("三包信息表删除成功：车架号: {}", vehicleNo);
            } else {
                throw new BusinessException("车架号:" + vehicleNo + "未在门店下，不能进行解绑三包");
            }
        }
        //删除电池激活信息
//        delBatteryGuaranteesByVehicleNo(vehicleNos);
        return true;
    }


    @Override
    public PagingVO<CarMaintainCardVO> pageApp(CarOwnerMaintainCardPageParam car, List<Long> collect) {

        car.setSalesOutletsIds(collect);
        PagingVO<CarMaintainCardVO> page = carMaintainCardRepoProc.page(car);
        fillCustInfo(page.getRecords());
        return page;
    }


    /**
     * @param buyDate 购买时间
     * @param time    三包期
     * @param d       生产日期
     * @param uom     单位
     * @return
     */
    private static LocalDate getTime2(LocalDate buyDate, Double time, LocalDate d, String uom) {

        int timeVal = time.intValue();
        if (uom.equals("Y")) {
            // 年
            LocalDate localDate = buyDate.plusYears(timeVal);
            return localDate;
        } else {
            // 月
            LocalDate localDate1 = buyDate.plusMonths(timeVal);
            return localDate1;
        }


    }

    /**
     * 有bug、已废弃
     *
     * @return
     */
    private static void getTime3(LocalDate date, Double time, LocalDate d, String uom) {

//        if (d != null && d.isBefore(LocalDate.of(2023, 1, 1))) {
//            date = d;
//        }
//        //double t = time;
//
//        // 如果单位是年，获取购买日期的年，直接相加
//        if (uom.equals("Y")) {
//            int year = time.intValue();
//            year = date.getYear() + year;
//
//            date = LocalDate.of(year, date.getMonthValue(), date.getDayOfMonth());
//            return date;
//        } else {
//            // 单位是月
//            // 获取购买日期的年
//            int year = date.getYear();
//            // 获取三包时间
//            int value = time.intValue();
//            // 判断月份够不够一年，如果够，够几个
//            do {
//                value -= 12;
//                year += 1;
//            } while (value > 0);
//
//            // 得到年月，用的do while ，年多加了1，月多减了12
//            year -= 1;
//            value += 12;
//            value += date.getMonthValue();
//            if (value > 12) {
//                year += 1;
//                value -= 12;
//            }
//            date = LocalDate.of(year, value, date.getDayOfMonth());
//            return date;
//        }

/*        Double aDouble = new Double(t);
        int year = aDouble.intValue();

        double m = time - year;
        m = 12 * m;
        year = date.getYear() + year;

        long mon = (int) m;

        LocalDate localDate = LocalDate.of(year, date.getMonthValue(), date.getDayOfMonth());

        localDate.minusMonths(mon);
        String retDate = localDate.minusMonths(-mon).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));

        LocalDate thisDate = LocalDate.parse(retDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return thisDate;*/

    }

    private List<ItmWarrantyConfigRpcDTO> getConfig(ItmWarrantyConfigRpcQueryParam param){
        List<ItmWarrantyConfigRpcDTO> config = itmWarrantyConfigRpcProvider.getConfig(param);
        if(!org.springframework.util.CollectionUtils.isEmpty(config)){
            Map<String, List<ItmWarrantyConfigRpcDTO>> map = config.stream().collect(Collectors.groupingBy(ItmWarrantyConfigRpcDTO::getItemType3));
            List<ItmWarrantyConfigRpcDTO> finalList = new ArrayList<>();
            if(org.apache.commons.lang3.StringUtils.isNotEmpty(param.getSpuCode()) && org.apache.commons.lang3.StringUtils.isNotEmpty(param.getItemGroup2())){
                //有车型和标配，先同时匹配车型和标配，如果匹配不到，则匹配车型，若再次匹配不到，则取默认配置
                map.keySet().forEach(x ->{
                    List<ItmWarrantyConfigRpcDTO> list1 = map.get(x);
                    List<ItmWarrantyConfigRpcDTO> list2 = list1.stream().filter(y -> param.getSpuCode().equals(y.getSpuCode()) && param.getItemGroup2().equals(y.getItemGroup2())).collect(Collectors.toList());
                    if(org.springframework.util.CollectionUtils.isEmpty(list2)){
                        Optional<ItmWarrantyConfigRpcDTO> op = list1.stream().filter(y -> null == y.getItemGroup2() && param.getSpuCode().equals(y.getSpuCode())).findAny();
                        if(op.isPresent()){
                            finalList.add(op.get());
                        }else {
                            Optional<ItmWarrantyConfigRpcDTO> op2 = list1.stream().filter(y -> null == y.getItemGroup2() && null == y.getSpuCode()).findAny();
                            op2.ifPresent(finalList::add);
                        }
                    }else {
                        finalList.add(list2.get(0));
                    }
                });
            }else if(org.apache.commons.lang3.StringUtils.isNotEmpty(param.getSpuCode())){
                map.keySet().forEach(x ->{
                    List<ItmWarrantyConfigRpcDTO> list1 = map.get(x);
                    List<ItmWarrantyConfigRpcDTO> list2 = list1.stream().filter(y -> param.getSpuCode().equals(y.getSpuCode()) && null == y.getItemGroup2()).collect(Collectors.toList());
                    if(org.springframework.util.CollectionUtils.isEmpty(list2)){
                        Optional<ItmWarrantyConfigRpcDTO> op = list1.stream().filter(y -> null == y.getItemGroup2() && null == y.getSpuCode()).findAny();
                        op.ifPresent(finalList::add);
                    }else {
                        finalList.add(list2.get(0));
                    }
                });
            }else {
                //没有具体商品编码，无法取到颜色和标配，默认返回
                map.keySet().forEach(x ->{
                    List<ItmWarrantyConfigRpcDTO> list1 = map.get(x);
                    Optional<ItmWarrantyConfigRpcDTO> op  = list1.stream().filter(y -> null == y.getSpuCode() && null == y.getItemGroup2()).findAny();
                    op.ifPresent(finalList::add);
                });
            }

            return finalList;
        }
        return config;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updIdCard(CarOwnverCardUpdParam updParam) {
        Optional<CarMaintainCardDO> op = this.carMaintainCardRepo.findById(updParam.getId());
        if(op.isEmpty()){
            throw new BusinessException("三包信息未查询到");
        }
        CarMaintainCardDO carMain = op.get();
        if(StringUtils.isNotBlank(carMain.getUserIdCard())) {
            throw new BusinessException("当前三包信息身份证号码不为空");
        }
        String idcard = updParam.getIdcard();

        if(updParam.getIdcard() != null){
            int countByUserIdCard = carOwnerVehicleRepo.findCountByUserIdCard(updParam.getIdcard());
            if(countByUserIdCard == 1){
                throw new BusinessException("此用户身份证号已绑定一辆车，请先解绑再绑定");
            }
        }
        carMain.setUserIdCard(idcard);
        this.carMaintainCardRepo.save(carMain);
        // 同步更新车主车辆信息表
        CarOwnerVehicleInfoDO vehicleInfo = this.carOwnerVehicleRepo.findByVehicleNo(carMain.getVehicleNo());
        if(vehicleInfo != null) {
//            String userPhone = vehicleInfo.getUserPhone();
            vehicleInfo.setUserIdCard(idcard);
            this.carOwnerVehicleRepo.save(vehicleInfo);
        }
    }
}
