package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Context:
 * @title: maintian_card_config
 * @Author： 郑杰
 * @Date: 2023/2/14 9:49
 */
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "maintian_card_config")
@org.hibernate.annotations.Table(appliesTo = "maintian_card_config", comment = "车辆配件三包配置表")
@Data
@ApiModel(value = "maintian_card_config", description = "车辆配件三包配置表")
@Where(clause = "delete_flag = 0")
public class MaintainCardConfigDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;
    
    @Column(name = "mountings_type")
    private String mountingsName;
    
    @Column(name = "code")
    private String code;
    
    @Column(name = "name")
    private String name;
    
    @Column(name = "erp_code")
    private String erpCode;
    
    @Column(name = "erp_name")
    private String erpName;
    
    @Column(name = "consumer_three_pack")
    private double consumerThreePack;
    
    @Column(name = "dealer_three_pack")
    private double dealerThreePack;
    
    @Column(name = "contain_three_pack")
    private String containThreePack;
    
    @Column(name = "notContain_three_pack")
    private String notContainThreePack;
    
    @Column(name = "remarks")
    private String remarks;
    
    @Column(name = "update_time")
    private LocalDate updateTime;
    
    @Column(name = "vehicle_type")
    private String vehicleType;
    
    
}
