package com.elitesland.yst.production.aftersale.model.entity.picture;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


@EqualsAndHashCode(callSuper = true)
@Entity
@Table(name = "picture_order")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "picture_order", comment = "工单图片")
@Data
@Accessors(chain = true)
@ApiModel(value = "工单图片", description = "工单图片")
public class PictureOrderDO extends BaseModel  implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("地址信息")
    @Column(name = "url", columnDefinition = "varchar(255)  comment '地址信息'")
    String url;

    @ApiModelProperty("编码")
    @Column(name = "code", columnDefinition = "varchar(100)  comment '编码'")
    String code;

    @ApiModelProperty("工单id")
    @Column(name = "order_id", columnDefinition = "bigint default 0  comment '工单id'")
    Long orderId;

    @ApiModelProperty("单据类型")
    @Column(name = "order_type", columnDefinition = "varchar(40)  comment '单据类型'")
    String orderType;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof PictureOrderDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
