package com.elitesland.yst.production.aftersale.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Context:
 * @title: vehicleThreePackage
 * @Author： 郑杰
 * @Date: 2023/2/14 10:48
 */
@Data
@ApiModel(description = "车辆绑定三包激活保存参数")
public class CarMaintainCardParam implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;
    
    @ApiModelProperty("车架号")
    @NotNull(message = "车架号不能为空！")
    private String vehicleNo;
    
    @ApiModelProperty("购买日期")
    @NotNull(message = "购买日期不能为空")
    private LocalDate purchaseTime;
    
    @ApiModelProperty("车主id")
    @NotNull(message = "未查询到相关客户信息！")
    private Long carOwnerId;

    @ApiModelProperty(value = "车架号集合")
    private List<String> vehicles;
    
    @ApiModelProperty(value = "生产日期")
    private LocalDate productionDate;

    @ApiModelProperty("生产日期(前端传入)")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;
    
    @ApiModelProperty("车型")
    private String vehicleType;


    @ApiModelProperty(value = "车辆来源 1-立马 0-非立马")
    private Integer vehicleSource;

    @ApiModelProperty("购买金额")
    private BigDecimal vehicleBuyPrice;


    @ApiModelProperty("车主身份证号")
    private String userIdCard;

    @ApiModelProperty("车主性别")
    private String userSex;

    @ApiModelProperty("车主地区")
    private String userArea;

    @ApiModelProperty("车主生日")
    private LocalDate userBirthday;

    private String sourcePlatform;

    @ApiModelProperty(value = "销售门店名称")
    private String salesOutletsName;

    @ApiModelProperty(value = "销售门店编码")
    private String salesOutletsCode;

    @ApiModelProperty(value = "销售门店编码")
    private Long salesOutletsId;

    @ApiModelProperty(value = "车型")
    private String spuCode;

    @ApiModelProperty(value = "标配")
    private String itemGroup2;
    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;


}
