package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/24
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderEvaluationPageParam extends AbstractOrderQueryParam {

    @ApiModelProperty("工单类型")
    private String orderType;

    @ApiModelProperty("工单编号")
    private String orderNo;

    @ApiModelProperty("手机号")
    private String orderTel;

    @ApiModelProperty("客户名称")
    private String orderPerson;

    @ApiModelProperty("门店id列表")
    private List<Long> storeIds;

    @ApiModelProperty("门店名称")
    private String repairStoreName;

    @ApiModelProperty("回访状态")
    private String returnStatus;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("评价级别(1：满意，2：不满意)")
    private String evaluationLevel;

    @ApiModelProperty("客诉类型(1：C端客诉，2：B端客诉)")
    private String complaintType;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof OrderEvaluationPageParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
