package com.elitesland.yst.production.aftersale.model.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "pc车主信息管理分页查询返回参数")
public class CarOwnerInfoMngRespVO implements Serializable {

    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("车主ID")
    @ExcelProperty("车主ID")
    private Long carOwnerId;

    @ApiModelProperty("统一认证中心的用户ID")
    private Long casUserId;

    @ApiModelProperty("open_id")
    private String openId;

    @ApiModelProperty("头像文件编码")
    private String fileCode;

    @ApiModelProperty("完整路径")
    private String url;

    @ApiModelProperty("车主姓名")
    @ExcelProperty("姓名")
    private String userName;

    @ApiModelProperty("性别 0-女 1-男")
    @SysCode(sys = "yst-after-sale", mod = "SEX")
    private Integer sex;
    @ExcelProperty("性别")
    private String sexName;

    @ApiModelProperty("生日")
    @ExcelProperty("生日")
    private LocalDateTime birthdayTime;

    @ApiModelProperty("车主手机号")
    @ExcelProperty("手机号")
    private String userPhone;

    @ApiModelProperty("启用状态 1-启用 0-禁用")
    @SysCode(sys = "yst-after-sale", mod = "ENABLED_FLAG")
    private Integer enabledFlag;
    @ExcelProperty("状态")
    private String enabledFlagName;

    @ApiModelProperty("创建时间")
    @ExcelProperty("加入时间")
    private LocalDateTime createTime;

    @ApiModelProperty("绑定车辆信息")
    List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS;
}
