package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderEvaluationVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("评价级别(1：满意，2：不满意)")
    @SysCode(sys = "yst-after-sale", mod = "EVALUATION_LEVEL")
    private String evaluationLevel;
    private String evaluationLevelName;

    @ApiModelProperty("评语")
    private String evaluationContent;

    @ApiModelProperty("工单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orderId;

    @ApiModelProperty("工单类型(1：维修工单，2：客诉工单)")
    @SysCode(sys = "yst-after-sale", mod = "EVALUATION_ORDER_TYPE")
    private String orderType;
    private String orderTypeName;

    @ApiModelProperty("客诉类型(1：C端客诉，2：B端客诉)")
    @SysCode(sys = "yst-after-sale", mod = "COMPLAINT_TYPE")
    private String complaintType;
    private String complaintTypeName;

    @ApiModelProperty("回访满意度")
    @SysCode(sys = "yst-after-sale", mod = "RETURN_LEVEL")
    private String returnLevel;
    private String returnLevelName;

    @ApiModelProperty("改善意见")
    private String returnAdvice;

    @ApiModelProperty("处理回复")
    private String returnReply;

    @ApiModelProperty("所属门店")
    private String repairStoreName;

    @ApiModelProperty("门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long repairStoreId;

    @ApiModelProperty("客户姓名")
    private String orderPerson;

    @ApiModelProperty("客户手机号")
    private String orderTel;

    @ApiModelProperty("工单id")
    private String orderNo;

    @ApiModelProperty("客诉信息")
    private String issueDescription;

    @ApiModelProperty("图片信息")
    List<PictureOrderVO> pictureOrderVOS;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof OrderEvaluationVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
