package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepoProc;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

@Service
@Log4j2
public class PictureOrderServiceImpl implements PictureOrderService {
    @Autowired
    private PictureOrderRepoProc pictureOrderRepoProc;

    @Autowired
    private SystemService systemService;


    @Override
    @SysCodeProc
    public ApiResult<List<PictureOrderVO>> query(PictureOrderParam queryDTO) {
        List<PictureOrderVO> pictureOrderVOS = pictureOrderRepoProc.query(queryDTO);
        //udc手动翻译
        this.udcTranslate(pictureOrderVOS);
        return ApiResult.ok(pictureOrderVOS);
    }

    /**
     * UDC翻译
     *
     * @param pictureOrderVOS
     */
    public void udcTranslate(List<PictureOrderVO> pictureOrderVOS) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.PICTURE_ORDER_TYPE_2.getModel(), UdcEnum.PICTURE_ORDER_TYPE_2.getCode());
        pictureOrderVOS.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getOrderType())) {
                t.setOrderTypeName(ajStatusMap.get(t.getOrderType()));
            }
        });
    }

}
