package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class RepairOrderExlParam extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("唯一标识")
    Long id;

    @ApiModelProperty("唯一标识集合")
    List<Long> idList;

    @ApiModelProperty("工单单号")
    String orderNo;

    @ApiModelProperty("维修备注")
    String repairRemark;

    @ApiModelProperty("车主信息id")
    Long personalId;

    @ApiModelProperty("车主车辆信息id")
    Long personalVehicelId;

    @ApiModelProperty("维修门店id")
    Long repairStoreId;
    List<Long> repairStoreIdS;

    @ApiModelProperty("维修门店名称")
    String repairStoreName;

    @ApiModelProperty("维修门店编号")
    String repairStoreCode;

    @ApiModelProperty("门店名称&编号")
    String StoreNameAndCode;

    @ApiModelProperty("联系人")
    String orderPerson;

    @ApiModelProperty("联系电话")
    String orderTel;

    @ApiModelProperty("车架号")
    String vehicleNo;

    @ApiModelProperty("问题描述")
    String questionRemark;

    @ApiModelProperty("工单状态")
    String orderStatus;
    List<String> orderStatusList;

    @ApiModelProperty("工单或客户手机号")
    String orderNoAndCustPhone;

    @ApiModelProperty("创建时间--开始")
    private LocalDateTime createTimeFrom;

    @ApiModelProperty("创建时间--结束")
    private LocalDateTime createTimeTo;

    @ApiModelProperty("客户名称或手机号")
    String custNameAndPhone;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairOrderExlParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
