package com.elitesland.yst.production.aftersale.provider.system;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateTxtReplaceDTO;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * 消息发送MSG
 * @package com.elitesland.yst.production.aftersale.provider.system
 * @date 2023/6/7 09:41
 */

@Component
@Log4j2
public class SysMsgRpcProvider {

    @Autowired
    private SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;

    /**
     * @param sendParamDTO
     * @param emReplaceMap  占位符替换 emReplaceMap.put("name", "测试模板邮件替换");
     * @param inReplaceMap  占位符替换 emReplaceMap.put("name", "测试模板站内替换");
     * @param smsReplaceMap 占位符替换 emReplaceMap.put("name", "测试模板短信替换");
     * @return
     */
    public String sendEmployeeMsg(TemplateEmployeeSendParamDTO sendParamDTO, Map<String, String> emReplaceMap, Map<String, String> inReplaceMap, Map<String, String> smsReplaceMap) {

        // 模板code 不能为空
        if (StringUtils.isBlank(sendParamDTO.getTemplateCode())) {
            throw new BusinessException("templateCode不能为空");
        }
        // 发送人 不能为空
//        if (null == sendParamDTO.getSendUser()) {
//            throw new BusinessException("sendUser不能为空");
//        }
        // 接收人 不能为空
        if (CollectionUtils.isEmpty(sendParamDTO.getRecipientUserList())) {
            throw new BusinessException("recipientUserList不能为空");
        }

        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();
        /**邮件信息***/
        TemplateTxtReplaceDTO emailDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.EMAIL)
                .replaceMap(emReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(emailDTO);
        /**邮件信息***/

        /**站内信息***/
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(inReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/

        /**短信信息***/
        TemplateTxtReplaceDTO smsDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.MOBILE_SMS)
                .replaceMap(smsReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(smsDTO);
        /**站内信息***/
        sendParamDTO.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        sendParamDTO.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        ApiResult<String> apiResult = null;
        try {
            apiResult = sysMsgTemplateSendRpcService.msgTemplateEmployeeSend(sendParamDTO);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return "send";
    }


    /**
     * 发送自定义消息
     *
     * @param sendParamDTO
     * @param emReplaceMap      占位符替换 emReplaceMap.put("name", "测试模板邮件替换");
     * @param inReplaceMap      占位符替换 emReplaceMap.put("name", "测试模板站内替换");
     * @param smsReplaceMap     占位符替换 emReplaceMap.put("name", "测试模板短信替换");
     * @param recipientUserList 接收人List
     * @return
     */
    public String sendCustomMsg(TemplateAssignSendParamDTO sendParamDTO, Map<String, String> emReplaceMap, Map<String, String> inReplaceMap, Map<String, String> smsReplaceMap, List<TemplateAssignRecipientUserDTO> recipientUserList) {

        // 模板code 不能为空
        if (StringUtils.isBlank(sendParamDTO.getTemplateCode())) {
            throw new BusinessException("templateCode不能为空");
        }
        // 发送人 不能为空
//        if (null == sendParamDTO.getSendUser()) {
//            throw new BusinessException("sendUser不能为空");
//        }
        // 接收人 不能为空
        if (CollectionUtils.isEmpty(recipientUserList)) {
            throw new BusinessException("recipientUserList不能为空");
        }

        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();
        /**邮件信息***/
        TemplateTxtReplaceDTO emailDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.EMAIL)
                .replaceMap(emReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(emailDTO);
        /**邮件信息***/

        /**站内信息***/
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(inReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/

        /**短信信息***/
        TemplateTxtReplaceDTO smsDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.MOBILE_SMS)
                .replaceMap(smsReplaceMap)
                .build();

        templateTxtReplaceDTOS.add(smsDTO);
        /**站内信息***/
        sendParamDTO.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        sendParamDTO.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        //发送人 start
//        MsgSendEmployeeUserDTO sendUser = MsgSendEmployeeUserDTO.builder()
//                .userCode("adminCode")
//                .userName("admin")
//                .userId(26183177199419838L)
//                .build();
//        sendParamDTO.setSendUser(sendUser);
        //发送人 end

        //接收人 start
//        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map1 = new HashMap<>();
//        map1.put(MsgSendTypeEnum.EMAIL,
//                TemplateAssignRecipientUserAccountDTO.builder().account("Charlie.chen@elitesland.com").build());
//        map1.put(MsgSendTypeEnum.MOBILE_SMS,
//                TemplateAssignRecipientUserAccountDTO.builder().account("15136125108").build());

//        List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();
//        TemplateAssignRecipientUserDTO recipient1 = TemplateAssignRecipientUserDTO.builder()
//                .userId(26515388624798699L)
//                .userName("niuchen1234")
//                .recipientUserAccountDtoMap(map1)
//                .build();
//        recipientUserList.add(recipient1);

        // 接收人2
//        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map2 = new HashMap<>();
//        map2.put(MsgSendTypeEnum.EMAIL,
//                TemplateAssignRecipientUserAccountDTO.builder().account("Kaiser.wang@elitesland.com").build());
//        map2.put(MsgSendTypeEnum.MOBILE_SMS,
//                TemplateAssignRecipientUserAccountDTO.builder().account("13523496731").build());
//        TemplateAssignRecipientUserDTO recipient2 = TemplateAssignRecipientUserDTO.builder()
//                .userId(685451965261485398L)
//                .userName("WWW")
//                .recipientUserAccountDtoMap(map2)
//                .build();
//        recipientUserList.add(recipient2);

        // 接收人3
//        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
//        map3.put(MsgSendTypeEnum.EMAIL,
//                TemplateAssignRecipientUserAccountDTO.builder().account("chen.niu@elitesland.com").build());
//        map3.put(MsgSendTypeEnum.MOBILE_SMS,
//                TemplateAssignRecipientUserAccountDTO.builder().account("13607654220").build());
//        TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder()
//                .userId(687286284481272935L)
//                .userName("test12132135")
//                .recipientUserAccountDtoMap(map3)
//                .build();
//        recipientUserList.add(recipient3);

        sendParamDTO.setRecipientUserList(recipientUserList);
        //发送人 end
        ApiResult<String> apiResult = null;
        try {
            apiResult = sysMsgTemplateSendRpcService.msgTemplateMsgTypeParamSend(sendParamDTO);

        } catch (Exception e) {
            log.error(e.getMessage());
        }

        return "cSend";

    }

    /**
     * 发送用户站内信
     *
     * @param sendParamDTO
     * @param inReplaceMap      占位符替换 emReplaceMap.put("name", "测试模板站内替换");
     * @param recipientUserList 接收人List
     */
    public void sendCustomInteriorMsg(TemplateAssignSendParamDTO sendParamDTO, Map<String, String> inReplaceMap, List<TemplateAssignRecipientUserDTO> recipientUserList) {

        // 模板code 不能为空
        if (StringUtils.isBlank(sendParamDTO.getTemplateCode())) {
            throw new BusinessException("templateCode不能为空");
        }

        // 接收人 不能为空
        if (CollectionUtils.isEmpty(recipientUserList)) {
            throw new BusinessException("recipientUserList不能为空");
        }

        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();

        /**站内信息***/
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(inReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/


        /**站内信息***/
        sendParamDTO.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        sendParamDTO.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        sendParamDTO.setRecipientUserList(recipientUserList);
        //发送人 end
        ApiResult<String> apiResult = null;
        try {
            apiResult = sysMsgTemplateSendRpcService.msgTemplateMsgTypeParamSend(sendParamDTO);

        } catch (Exception e) {
            log.error(e.getMessage());
        }

    }

    /**
     * 发送员工站内信
     *
     * @param sendParamDTO
     * @param inReplaceMap      占位符替换 emReplaceMap.put("name", "测试模板站内替换");
     * @param recipientUserList 接收人List
     */
    public void sendEmployeeInteriorMsg(TemplateEmployeeSendParamDTO sendParamDTO, Map<String, String> inReplaceMap, List<MsgRecipientUserDTO> recipientUserList) {

        // 模板code 不能为空
        if (StringUtils.isBlank(sendParamDTO.getTemplateCode())) {
            throw new BusinessException("templateCode不能为空");
        }

        // 接收人 不能为空
        if (CollectionUtils.isEmpty(recipientUserList)) {
            throw new BusinessException("recipientUserList不能为空");
        }

        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();

        /**站内信息***/
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(inReplaceMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/


        /**站内信息***/
        sendParamDTO.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        sendParamDTO.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        sendParamDTO.setRecipientUserList(recipientUserList);
        //发送人 end
        ApiResult<String> apiResult = null;
        try {
            apiResult = sysMsgTemplateSendRpcService.msgTemplateEmployeeSend(sendParamDTO);

        } catch (Exception e) {
            log.error(e.getMessage());
        }

    }

}

