package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.excel.common.param.ExportColumnParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.convert.PhoneRecordConvert;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecordService;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecordRepo;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecordRepoProc;

import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;


import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PhoneRecordServiceImpl implements PhoneRecordService {

    private final PhoneRecordRepoProc phoneRecordRepoProc;
    private final PhoneRecordRepo phoneRecordRepo;

    private final SysUdcProxyService sysUdcProxyService;

    private final UserService userService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PhoneRecordDO save(PhoneRecordParam phoneRecordParam) {
        //必填校验
        this.checkData(phoneRecordParam);
        phoneRecordParam.setFollowUpFlag(phoneRecordParam.getFollowUpFlag() == null ? false : phoneRecordParam.getFollowUpFlag());
        PhoneRecordDO phoneRecordDO = PhoneRecordConvert.INSTANCE.saveVoTODO(phoneRecordParam);

        // 0711 新增记录人信息
        SysUserDTO userDetail = userService.getUserDetail();
        phoneRecordDO.setCreateName(userDetail.getLastName());

        PhoneRecordDO res = phoneRecordRepo.save(phoneRecordDO);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PhoneRecordDO update(PhoneRecordParam phoneRecordParam) {
        Assert.notNull(phoneRecordParam.getId(), "id is null");
        PhoneRecordDO res = save(phoneRecordParam);
        return res;
    }

    @Override
    @SysCodeProc
    public PhoneRecordVO get(Long id) {
        PhoneRecordVO res = phoneRecordRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<PhoneRecordVO> page(PhoneRecordPageParam phoneRecordPageParam) {
        PagingVO<PhoneRecordVO> res = phoneRecordRepoProc.page(phoneRecordPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
        Long res = phoneRecordRepoProc.del(ids);
        return res;
    }

    /**
     * 数据校验
     *
     * @param phoneRecordParam
     */
    private void checkData(PhoneRecordParam phoneRecordParam) {
        if (phoneRecordParam.getRecordTime() == null) {
            throw new BusinessException("日期为空，请检查");
        }
        if (phoneRecordParam.getCityCode() == null || phoneRecordParam.getCityName() == null) {
            throw new BusinessException("城市为空，请检查");
        }
        if (phoneRecordParam.getContacts() == null) {
            throw new BusinessException("联络人为空，请检查");
        }
        if (phoneRecordParam.getContactPhone() == null) {
            throw new BusinessException("联系电话为空，请检查");
        }
        if (phoneRecordParam.getCustType() == null) {
            throw new BusinessException("客户类型为空，请检查");
        }
        if (phoneRecordParam.getCallType() == null) {
            throw new BusinessException("来电类型为空，请检查");
        }
        if (phoneRecordParam.getCallContent() == null) {
            throw new BusinessException("通话内容为空，请检查");
        }
    }

    @Override
    public PagingVO<PhoneRecordVO> export(PhoneRecordPageParam param) {
        PagingVO<PhoneRecordVO> page = this.page(param);
        sysUdcProxyService.translate(page.getRecords());
        page.stream().forEach(t -> {
            t.setFollowUpFlagName(t.getFollowUpFlag() ? "是" : "否");
            if (t.getServiceSatisfied() != null) {
                switch (t.getServiceSatisfied()) {
                    case 1:
                        t.setServiceSatisfiedName("满意");
                        break;
                    case 2:
                        t.setServiceSatisfiedName("十分满意");
                        break;
                    case 3:
                        t.setServiceSatisfiedName("不满意");
                        break;
                    default:
                        throw new BusinessException("数据来源异常");
                }
            }
        });
        return page;
    }

}