package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.StoreParam;
import com.elitesland.yst.production.aftersale.model.vo.StoreVO;
import com.elitesland.yst.production.aftersale.service.StoreService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Log4j2
public class StoreServiceImpl implements StoreService {


    /**
     * 支撑域暂时无法支持，本接口先写死返回数据，便于联调
     *
     * @param queryDTO 查询参数
     * @return
     */
    @Override
    public PagingVO<StoreVO> query(StoreParam queryDTO) {
        List<StoreVO> collect = this.sendList(queryDTO);
        List<StoreVO> storeVOS = collect.stream().filter(t -> t.getStoreName().equals(queryDTO.getStoreName())).collect(Collectors.toList());
        return this.subList(storeVOS, queryDTO.getCurrent() + 1, queryDTO.getSize());
    }

    //subList手动分页，page为第几页，rows为每页个数
    public PagingVO<StoreVO> subList(List<StoreVO> list, int page, int rows) {
        List<StoreVO> listSort = new ArrayList<>();
        int size = list.size();
        int pageStart = page == 1 ? 0 : (page - 1) * rows;//截取的开始位置
        int pageEnd = size < page * rows ? size : page * rows;//截取的结束位置
        if (size > pageStart) {
            listSort = list.subList(pageStart, pageEnd);
        }
        //总页数
        int totalPage = list.size() / rows;

        return PagingVO.<StoreVO>builder()
                .total(size)
                .records(listSort)
                .build();
    }

    @Override
    public List<StoreVO> sendList(StoreParam queryDTO) {
        //暂时返回特定数据
        List<StoreVO> storeVOList = new ArrayList<>();
        List<String> typeList = new ArrayList<>();
        typeList.add("维修");
        typeList.add("售后");
        for (int i = 0; i < 12; i++) {
            StoreVO storeVO = new StoreVO();
            storeVO.setId(Long.valueOf(20230216 + i));
            storeVO.setStoreName("台州立马工厂店" + i);
            storeVO.setStoreCode("LIMA" + i);
            storeVO.setTel("1333333333" + i);
            storeVO.setUrl("台州市台州湾新区三甲街道甲南大道3505-" + i);
            storeVO.setStoreDistance(String.valueOf(i));
            storeVO.setBusinessTime(LocalDateTime.now());
            storeVO.setServiceTypes(typeList);
            switch (i) {
                case 0:
                    storeVO.setLatitude(34.723930);
                    storeVO.setLongitude(113.640179);
                    break;
                case 1:
                    storeVO.setLatitude(34.528690);
                    storeVO.setLongitude(112.487070);
                    break;
                // 审批拒绝
                case 2:
                    storeVO.setLatitude(29.650237);
                    storeVO.setLongitude(91.133847);
                    break;
                // 审批中
                default:
                    storeVO.setLatitude((double) (i * i));
                    storeVO.setLongitude((double) (i + i));
                    break;
            }

            storeVOList.add(storeVO);
        }
        return storeVOList;
    }


}
