package com.elitesland.yst.production.aftersale.service.repo;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.*;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;



@Repository
public class ItemBackupsRepoProc extends BaseRepoProc<ItemBackupsDO> {

    private static final QItemBackupsDO QTY = QItemBackupsDO.itemBackupsDO;
    @Autowired
    private ItemBackupsRepo itemBackupsRepo;
    protected ItemBackupsRepoProc() {
        super(QTY);
    }

    public List<ItemBackupsDO> itemQuery(String code) {
        Iterable<ItemBackupsDO> all = itemBackupsRepo.findAll(
                QTY.itemCode.eq(code));
        if(!IterUtil.isEmpty(all)){
            return Lists.newArrayList(all);
        }
        return null;

    }
}
