/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.convert.CarConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.ItemBackupsDO;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.VehicleQueryParam;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryVehicleVO;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.LmItmItemRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.repo.BatteryVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.ItemBackupsRepoProc;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.LmItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcParam;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CarServiceImpl
implements CarService {
    private static final Logger log = LogManager.getLogger(CarServiceImpl.class);
    @Autowired
    private LmItmItemRpcProvider lmItmItemRpcProvider;
    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;
    @Autowired
    private ItemBackupsRepoProc itemBackupsRepoProc;
    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;
    @Autowired
    private BatteryVehicleRepoProc batteryVehicleRepoProc;

    @Override
    public ApiResult<List<CarVO>> queryList(CarParam queryDTO) {
        ArrayList<CarVO> carVOList = new ArrayList<CarVO>();
        CarVO storeRespVO = new CarVO();
        storeRespVO.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u3011ve110120130");
        storeRespVO.setVehicleSpecs("\u3010\u6d4b\u8bd5\u6570\u636e\u30118888");
        storeRespVO.setVehicleSource("\u3010\u6d4b\u8bd5\u6570\u636e\u3011\u7ebf\u4e0a\u9500\u552e");
        storeRespVO.setMaintainCardNo("\u3010\u6d4b\u8bd5\u6570\u636e\u301166666");
        storeRespVO.setVehicleType("\u3010\u6d4b\u8bd5\u6570\u636e\u3011\u8f66\u578b");
        carVOList.add(storeRespVO);
        return ApiResult.ok(carVOList);
    }

    @Override
    public ApiResult<CarVO> query(CarParam queryDTO) {
        CarMaintainCardDO carMaintainCardDO;
        log.info("\u8f66\u67b6\u53f7{}", (Object)queryDTO.getVehicleNo());
        VinOrderRpcDTO vinOrderRpcDTO = this.vinOrderRpcProvider.getByVinNo(queryDTO.getVehicleNo());
        CarVO carVO = CarConvert.INSTANCE.carRpcDTOTOVO(vinOrderRpcDTO);
        log.info("\u5e93\u5b58\u7269\u6599(\u5546\u54c1\u7f16\u7801) {}", (Object)vinOrderRpcDTO.getMtnrv());
        ItmItemRpcParam param = new ItmItemRpcParam();
        ArrayList<String> itemCodes = new ArrayList<String>();
        itemCodes.add(vinOrderRpcDTO.getMtnrv());
        param.setItemCodes(itemCodes);
        List<LmItmItemRpcDTO> lmItmItemList = this.lmItmItemRpcProvider.findSkuByParam(param);
        if (CollectionUtils.isNotEmpty(lmItmItemList)) {
            String itemAttr = lmItmItemList.get(0).getItemAttr();
            String color = null;
            JSONArray jsonArray = JSONArray.parseArray((String)itemAttr);
            for (Object ja : jsonArray) {
                JSONObject jsonObject = (JSONObject)ja;
                String name = jsonObject.getString("name");
                String value = jsonObject.getString("value");
                if (!"\u989c\u8272".equals(name)) continue;
                color = value;
            }
            String vehicleType = "";
            vehicleType = this.concatStr(vehicleType, lmItmItemList.get(0).getItemType5());
            vehicleType = this.concatStr(vehicleType, lmItmItemList.get(0).getItemType5Name());
            vehicleType = this.concatStr(vehicleType, lmItmItemList.get(0).getSpuName());
            carVO.setVehicleType(vehicleType);
            carVO.setVehicleColor(color);
            carVO.setVehicleSpecs(lmItmItemList.get(0).getItemName());
            carVO.setItemType3(lmItmItemList.get(0).getItemType3());
            carVO.setVehicleNo(vinOrderRpcDTO.getVinNo());
            carVO.setItemGroup2(lmItmItemList.get(0).getItemGroup2());
            carVO.setSpuCode(lmItmItemList.get(0).getSpuCode());
        } else {
            List<ItemBackupsDO> itemBackupsDOS = this.itemBackupsRepoProc.itemQuery(vinOrderRpcDTO.getMtnrv());
            if (CollectionUtils.isEmpty(itemBackupsDOS)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8f66\u8f86\u5c5e\u6027\u4fe1\u606f");
            }
            String vehicleType = "";
            vehicleType = this.concatStr(vehicleType, itemBackupsDOS.get(0).getItemType5());
            vehicleType = this.concatStr(vehicleType, itemBackupsDOS.get(0).getSpuName());
            carVO.setVehicleType(vehicleType);
            carVO.setVehicleColor(itemBackupsDOS.get(0).getColor());
            carVO.setVehicleSpecs(itemBackupsDOS.get(0).getItemName());
            carVO.setItemType3("230");
            carVO.setVehicleNo(vinOrderRpcDTO.getVinNo());
        }
        String veNo = carVO.getVehicleNo();
        LmVehicleNoTimeDTO vehicleNoInfo = this.vehicleNoRpcService.getDocTimeByVehicle(veNo);
        if (vehicleNoInfo != null) {
            carVO.setDocTime(vehicleNoInfo.getDocTime());
            carVO.setManufactureDate(vehicleNoInfo.getOfflineTime());
        }
        if ((carMaintainCardDO = this.carMaintainCardRepo.findByVehicleNoAndDeleteFlag(veNo, 0)) != null) {
            carVO.setBindActiveTime(carMaintainCardDO.getCreateTime());
        }
        VehicleQueryParam vehicleQueryParam = new VehicleQueryParam();
        vehicleQueryParam.setItemGroup2(carVO.getItemGroup2());
        vehicleQueryParam.setCode(carVO.getSpuCode());
        int batteryNum = 0;
        List<BatteryVehicleVO> list = this.batteryVehicleRepoProc.vehicleInfo(carVO.getItemGroup2(), carVO.getSpuCode());
        if (StringUtils.isBlank((String)carVO.getItemGroup2())) {
            for (BatteryVehicleVO batteryVehicleVO : list) {
                if (!StringUtils.isBlank((String)batteryVehicleVO.getItemGroup2())) continue;
                batteryNum = batteryVehicleVO.getBatteryNum();
                carVO.setSpuName(batteryVehicleVO.getSpuName());
                carVO.setBatteryNum(batteryNum);
                return ApiResult.ok((Object)carVO);
            }
        } else if (StringUtils.isNotBlank((String)carVO.getItemGroup2()) && CollectionUtils.isEmpty(list)) {
            List<BatteryVehicleVO> list1 = this.batteryVehicleRepoProc.vehicleInfo(null, carVO.getSpuCode());
            for (BatteryVehicleVO batteryVehicleVO : list1) {
                if (!StringUtils.isBlank((String)batteryVehicleVO.getItemGroup2())) continue;
                batteryNum = batteryVehicleVO.getBatteryNum();
                carVO.setSpuName(batteryVehicleVO.getSpuName());
                carVO.setBatteryNum(batteryNum);
                return ApiResult.ok((Object)carVO);
            }
        } else {
            BatteryVehicleVO batteryVehicleVO = list.get(0);
            batteryNum = batteryVehicleVO.getBatteryNum();
            carVO.setSpuName(batteryVehicleVO.getSpuName());
        }
        carVO.setBatteryNum(batteryNum);
        return ApiResult.ok((Object)carVO);
    }

    @Override
    public List<CarVO> carList() {
        ArrayList<CarVO> carVOList = new ArrayList<CarVO>();
        CarVO carVO = this.carSave();
        carVO.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u3011ve110120130");
        CarVO carVO1 = this.carSave();
        carVO1.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u3011yuanshen1234");
        CarVO carVO2 = this.carSave();
        carVO2.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u3011henan666");
        CarVO carVO3 = this.carSave();
        carVO3.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u30118555553568");
        CarVO carVO4 = this.carSave();
        carVO4.setVehicleNo("\u3010\u6d4b\u8bd5\u6570\u636e\u30118555553569");
        carVOList.add(carVO);
        carVOList.add(carVO1);
        carVOList.add(carVO2);
        carVOList.add(carVO3);
        carVOList.add(carVO4);
        return carVOList;
    }

    public CarVO carSave() {
        CarVO storeRespVO = new CarVO();
        storeRespVO.setVehicleSource("\u3010\u6d4b\u8bd5\u6570\u636e\u3011\u7ebf\u4e0a\u9500\u552e");
        storeRespVO.setMaintainCardNo("\u3010\u6d4b\u8bd5\u6570\u636e\u301166666");
        storeRespVO.setVehicleColor("\u3010\u6d4b\u8bd5\u6570\u636e\u3011\u5185\u8d34\u610f\u5f0f-\u6708\u5149\u767d+\u91d1\u5c5e\u8273\u7ea2+\u70ab\u5149\u84dd\u7eff+\u95ea\u7535\u94f6");
        storeRespVO.setVehicleSpecs("\u3010\u6d4b\u8bd5\u6570\u636e\u3011215-23\u7535\u673a/30A(ECU)/- \u952e\u4fee\u590d1\u524d\u94c1\u8f6e/3.00-10\u771f\u7a7a/\u03c627\u94dd\u76f4\u7b521/\u540e\u666e\u901a/\u524d\u540e\u789f\u5239/LED\u4eea\u8868/\u4e2d\u8f74/\u786c\u8d34/\u5185\u8d34/\u7279\u65af\u62c9WX");
        storeRespVO.setMachineNo("\u3010\u6d4b\u8bd5\u6570\u636e\u3011LM36V350WBBB012301022116");
        storeRespVO.setVehicleType("\u3010\u6d4b\u8bd5\u6570\u636e\u3011\u8f66\u578b");
        storeRespVO.setPurchaseTime(LocalDateTime.now());
        return storeRespVO;
    }

    public String concatStr(String name, String param) {
        if (!StringUtils.isEmpty((CharSequence)param)) {
            name = name.equals("") ? param : name.concat("/").concat(param);
        }
        return name;
    }
}

