package com.elitesland.yst.production.aftersale.common;

import com.elitescloud.boot.core.support.verifycode.common.content.DefaultCarrierContentProvider;
import com.elitescloud.cloudt.core.verifycode.model.VerifyCodeMessengerBO;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

/**
 * @author zhiyu.he
 * @date 2023/8/22 16:54
 */
@Component
@Log4j2
public class CarrierContent extends DefaultCarrierContentProvider {

    private final String  AFTER_KAPCHA="AFTER_KAPCHA";
    private final static String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";

    @Override
    public String produceContent(VerifyCodeMessengerBO param) {
        String verifyCode = param.getVerifyCode();
        switch (param.getBusinessType()) {
            case AFTER_KAPCHA:
                return "您的验证码是：" + verifyCode + "，仅用于注册，请不要将验证码透漏于他人！";
            case BUSINESS_TYPE_RETRIEVE_PWD:
                return "您的验证码是：" + verifyCode + "，仅用于找回登录密码，请不要将验证码透漏于他人！";
            default:
                log.error("暂不支持的业务类型：{}", param.getBusinessType());
                return null;
        }
    }

    @Override
    public String produceSubject(VerifyCodeMessengerBO param) {
        switch (param.getBusinessType()) {
            case AFTER_KAPCHA:
                return "验证码注册";
            case BUSINESS_TYPE_RETRIEVE_PWD:
                return "密码找回";
            default:
                log.error("暂不支持的业务类型：{}", param.getBusinessType());
                return null;
        }
    }
}
