package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.boot.excel.util.ExcelExportUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.search.service.ComplaintOrderSearchBeanService;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import lombok.val;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/23
 */
@RestController
@RequestMapping(value = "/pc/complaintOrder/search", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
@Validated
@Log4j2
@Api(value = "中台管理端客诉工单", tags = {"中台管理端客诉工单"})
public class PcComplaintOrderSearchController {

    private final ComplaintOrderSearchBeanService complaintOrderSearchBeanService;

    private final ExportExcelService<ComplaintOrderExlParam, ComplaintOrderVO, Serializable> exportExcelService;

    @PostMapping("/complaintOrderListQuery")
    @ApiOperation("客诉工单列表查询")
    public ApiResult<PagingVO<ComplaintOrderVO>> complaintOrderListQuery(@RequestBody ComplaintOrderPageParam param) {
        param.setSource("PC");
        PagingVO<ComplaintOrderVO> query = complaintOrderSearchBeanService.query(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/complaintOrderExport")
    @ApiOperation("客诉工单导出")
    public void complaintOrderExport(HttpServletResponse response, @RequestBody ComplaintOrderExlParam param) {
        ExcelUtils.buildExportColumn(param, ComplaintOrderVO.class);
        try {
            exportExcelService.export(param, response, complaintOrderSearchBeanService::export).get();
        } catch (Exception e) {
            log.error("客诉工单导出失败：{}", e);
        }
    }
}
