package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name = "battery_guarantees")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "battery_guarantees", comment = "电池激活列表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "battery_guarantees", description = "车型标配电池配置表")
public class BatteryGuaranteesDO extends BaseModel {

    @Comment("商品统一编码")
    @Column(length = 64)
    private String code;

    @Comment("商品类型")
    @Column(length = 64)
    private String type;

    @Comment("车主名称")
    @Column(length = 64)
    private String ownerName;

    @Comment("车主联系电话")
    @Column(length = 64)
    private String ownerMobile;

    @Comment("车主身份证号码")
    @Column(length = 64)
    private String idCard;

    @Column(name = "guarantees_time", columnDefinition = "datetime default null  comment '三包激活时间'")
    private LocalDateTime guaranteesTime;

    @Comment("整车车型")
    @Column(length = 64)
    private String vehicleType;

    @Comment("整车标配")
    @Column(length = 225)
    private String itemGroup2;

    @Comment("spuCode")
    @Column(length = 64)
    private String spuCode;

    @Comment("整车SPU")
    @Column(length = 64)
    private String spuName;

    @Comment("整车规格")
    @Column(length = 225)
    private String vehicleSpecs;

    @Comment("整车编码")
    @Column(length = 64)
    private String mtnrv;

//    @Comment("厂家商品编码")
//    @Column(length = 64)
//    private String fgCode;
//
//    @Comment("厂家编码")
//    @Column(length = 32)
//    private String factoryCode;
//
//    @Comment("厂家名称")
//    @Column(length = 32)
//    private String factoryName;
//
//    @Comment("产品品类")
//    @Column(length = 32)
//    private String prodCategory;
//
//    @Comment("产品规格")
//    @Column(length = 64)
//    private String prodSpecs;
//
//    @Comment("产品型号")
//    @Column(length = 64)
//    private String prodModel;
//
//    @Comment("产地")
//    @Column(length = 64)
//    private String producer;
//
//    @Column(name = "factory_out_time", columnDefinition = "datetime default null  comment '厂家出库时间'")
//    private LocalDateTime factoryOutTime;
//
//    @Column(name = "in_time", columnDefinition = "datetime default null  comment '入库时间'")
//    private LocalDateTime inTime;
//
//    @Column(name = "out_time", columnDefinition = "datetime default null  comment '出库时间'")
//    private LocalDateTime outTime;

    @Comment("经销商客户号")
    @Column(length = 64)
    private String custCode;

    @Comment("经销商客户号")
    @Column(length = 64)
    private String custCode2;

    @Comment("经销商名称")
    @Column(length = 64)
    private String dealerName;

    @Comment("门店id")
    @Column(length = 64)
    private String storeCode;

    @Comment("门店Code")
    @Column(length = 64)
    private String storeCode2;

    @Comment("门店id")
    @Column(length = 64)
    private String storeId;

    @Comment("门店名称")
    @Column(length = 64)
    private String storeName;

    @Comment("省份")
    @Column(length = 64)
    private String provinceName;

    @Column(length = 64)
    private String province;

    @ApiModelProperty("经销商区域")
    @Column(length = 64)
    private String saleRegion;
    @Column(length = 64)
    private String saleRegionName;

    @Comment("车架号")
    @Column(length = 64)
    private String vehicleNo;

}
