package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 客诉设置;
 * @author : http://www.chiner.pro
 * @date : 2023-2-28
 */
@ApiModel(value = "客诉设置",description = "客诉设置")
@Data
public class ComplaintSetVO extends BaseModelVO {
    @ApiModelProperty("分类编码")
    private String classifyCode;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("客诉类型(1:C端投诉, 2:B端投诉, 3:基本设置）")
    private String complaintType;

    @ApiModelProperty("启用状态")
    @SysCode(sys = "yst-after-sale", mod = "ENABLED_FLAG")
    private String enableFlag;
    private String enableFlagName;

    @ApiModelProperty("最大响应时间")
    private String maxResp;

    @ApiModelProperty("最大处理时间")
    private String maxHandle;

    @ApiModelProperty("问题描述")
    private String issueDesc;

    @ApiModelProperty("序号")
    private Integer sortNo;

    @ApiModelProperty("上级id")
    private Long pid;

    /** 下级分类 */
    @ApiModelProperty(value = "下级分类")
    private List<ComplaintSetVO> under;

    /** 是否拥有下级 */
    @ApiModelProperty(value = "是否拥有下级")
    private Boolean hasUnder;

}