package com.elitesland.yst.production.aftersale.out.sys;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiCode;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.aftersale.Application;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;

@Service
@AllArgsConstructor
@Slf4j
public class SystemServiceImpl implements SystemService {

    /**
     * 发号器
     */
    private final SeqNumProvider sysNumberRuleService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final UdcProvider udcProvider;
    private final ItmItemRpcService itemRpcService;
    private final SysUserRpcService sysUserService;

    @Override
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map<String, String> codeMap = udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap ;
        } catch (Exception e) {
            log.error("findCodeBatch error:", e);
        }
        return new HashMap<>();
    }

    /**
     * 发号器发号
     * @param code
     * @param runtimeValues
     * @return
     */
    @Override
    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {

        String sys ="";
        List<String> list = new ArrayList<>();
        list.addAll(runtimeValues);
        try {
            sys =sysNumberRuleService.generateCode(Application.NAME,code, list);
        } catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "发号器发号失败");
        }
        return sys;
    }

    /**
     * 商品库存参数配置模块 - 更据计划员工ID查询系统用户账号信息
     *
     * @param calcEmpIds userids
     * @return 系统用户集
     */
    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        try {
            if (calcEmpIds.isEmpty()) {
                return null;
            }
            List<SysUserVO> sysUserVOList = sysUserService.getByIds(calcEmpIds);
            if (!CollectionUtils.isEmpty(sysUserVOList)) {
                return sysUserVOList;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("通过ouId,自定义参数获取用户列表，时间：{}，入参：{}", LocalDateTime.now(), ouId);
        try {
            SysUserIdFlowRoleRpcParam param =new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            param.setFlowRoleCodes(Collections.singletonList(customParams));
            List<Long> userIds = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!org.springframework.util.CollectionUtils.isEmpty(userIds)) {
                return userIds;
            }
        } catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", e);
            throw new BusinessException( ApiCode.FAIL, e.getMessage());
        }
        return null;
    }

    @Override
    public SysUserDTO sysUserCurrent() {
        try {
            //return sysUserService.current();
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();;
            if (userDetails == null) {
                return null;
            }
            SysUserDTO sysUserDTO = userDetails.getUser();
            if (sysUserDTO == null) {
                return null;
            }
            return sysUserDTO;
        } catch (Exception e) {
            log.error("sysUserCurrent error:", e);
        }
        return null;
    }

//    /**
//     * 根获取区域信息列表
//     *
//     * @param param 入参
//     * @return 区域集
//     */
//    @Override
//    public List<ComCityCodeRpcDTO> findAreaByParam(ComCityCodeRpcDtoParam param) {
//        log.info("调用系统域-获取区域信息列表，时间：{}，入参：{}", LocalDateTime.now(), param);
//        /*if (org.springframework.util.CollectionUtils.isEmpty(areaCodes)){
//            return Collections.EMPTY_LIST;
//        }*/
//       // ComCityCodeRpcDtoParam param = new ComCityCodeRpcDtoParam();
//        //param.setAreaCodes(areaCodes);
//        try {
//            List<ComCityCodeRpcDTO> areas = comCityCodeRpcService.findRpcDtoByParam(param);
//            if (!org.springframework.util.CollectionUtils.isEmpty(areas)) {
//                return areas;
//            }
//        } catch (Exception e) {
//            log.error("findAreaByCodes error:", e);
//        }
//        return Collections.EMPTY_LIST;
//
//    }
}
