package com.elitesland.yst.production.aftersale.provider.system;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.system
 * @date 2023/4/27 09:09
 */

@Component
@Log4j2
public class SysAreaRpcProvider {

    @Autowired
    private SysAreaRpcService sysAreaRpcService;


    public List<SysAreaRespDTO> listByAreaCodes(Set<String> set) {
        ApiResult<List<SysAreaRespDTO>> dataResult = null;
        try {
            dataResult = sysAreaRpcService.listByAreaCodes(set);
        } catch (Exception e) {
            log.error(e);
            throw new BusinessException("调用system域失败:" + e.getMessage());
        }

        if (dataResult.getCode() != ApiCode.SUCCESS.getCode()) {
            throw new BusinessException("调用system域失败:" + dataResult.getMsg());
        }

        return dataResult.getData();

    }
}
