package com.elitesland.yst.production.aftersale.controller.front;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

/**
 * @author elvis.hong
 * @title FrontBindSoldVehicleController
 * @Date 2023/2/21
 */
@RestController
@RequestMapping(value = "/front/bindSoldVehicle", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "经销商pc端售出车辆绑定", tags = {"经销商pc端售出车辆绑定"})
public class FrontBindSoldVehicleController {

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;

    @PostMapping("/bindSoldVehicleQuery")
    @ApiOperation("售出车辆绑定分页查询")
    public ApiResult<PagingVO<BindSoldVehicleVO>> bindSoldVehicleQuery(@RequestBody BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> query = carOwnerVehicleService.bindSoldVehicleQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/bcBindSoldVehicleQuery")
    @ApiOperation("售出车辆绑定分页查询")
    public ApiResult<PagingVO<BindSoldVehicleVO>> bcBindSoldVehicleQuery(@RequestBody BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> query = carOwnerVehicleService.bcBindSoldVehicleQuery(param);
        return ApiResult.ok(query);
    }

    @GetMapping(value = "/bindSoldVehicleDetail/{id}")
    @ApiOperation(value = "售出车辆绑定明细查询")
    public ApiResult<CarOwnerVehicleInfoVO> bindSoldVehicleDetail(@PathVariable("id") Long id) {
        return ApiResult.ok(carOwnerVehicleService.bindSoldVehicleDetail(id));
    }

    @PostMapping(value = "/bindSoldVehicleSave")
    @ApiOperation(value = "售出车辆绑定信息保存")
    public ApiResult<Long> bindSoldVehicleSave(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {

        throw new BusinessException("该接口已进行升级,请刷新web页面");
//        carOwnerVehicleParam.setActivatFlag(false);
//        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam,"WEB");
//        return res;
    }


    @PostMapping(value = "/bindSoldVehicleSave2")
    @ApiOperation(value = "售出车辆绑定信息保存(不进行激活)")
    public ApiResult<Long> bindSoldVehicleSave2(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {
        carOwnerVehicleParam.setActivatFlag(false);
        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam,"WEB");
        return res;
    }

    @PostMapping(value = "/custDateRepair")
    @ApiOperation(value = "绑车客户信息修复")
    public ApiResult<Object> custDateRepair(@RequestBody BindSoldVehicleParam param) {
        return carOwnerVehicleService.custDateRepair(param);
    }


    @PostMapping(value = "/delThreePackage")
    @ApiOperation(value = "解绑车辆并删除三包信息")
    public ApiResult<Object> delThreePackage(@RequestBody Long id) {
        ApiResult<Object> res = carOwnerVehicleService.deleteBindVehicleAndThreePack(id);
        return res;
    }


}
