package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationPageParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author RYH
 * @date 2023/2/23
 */
@RestController
@RequestMapping(value = "/pc/orderEvaluation", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "中台管理端工单评价", tags = {"中台管理端工单评价"})
public class PcOrderEvaluationController {

    @Autowired
    private OrderEvaluationService orderEvaluationService;

    @PostMapping("/orderEvaluationSave")
    @ApiOperation("工单评价提交保存")
    public ApiResult<Long> complaintOrderSave(@RequestBody com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam saveVO) {
        Long ret = orderEvaluationService.save(saveVO);
        return ApiResult.ok(ret);
    }

    @PostMapping("/orderEvaluationQuery")
    @ApiOperation("工单评价查询")
    public ApiResult<PagingVO<OrderEvaluationVO>> repairOrderQuery(@RequestBody OrderEvaluationPageParam param) {
        PagingVO<OrderEvaluationVO> ret = orderEvaluationService.pageQuery(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/orderEvaluationDelete")
    @ApiOperation("工单评价删除")
    public ApiResult orderEvaluationDelete(@RequestBody List<Long> ids) {
        orderEvaluationService.orderEvaluationDelete(ids);
        return ApiResult.ok();
    }

    @PostMapping("/orderEvaluationSolve")
    @ApiOperation("工单评论回访")
    public ApiResult orderEvaluationSolve(@RequestBody com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam saveVO) {
        orderEvaluationService.orderEvaluationSolve(saveVO);
        return ApiResult.ok();
    }

}

