package com.elitesland.yst.production.aftersale.model.vo;

import cn.zhxu.bs.bean.DbField;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ComplaintOrderVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("工单单号")
    @ExcelProperty("售后工单号")
    private String orderNo;

    @ApiModelProperty("客诉类型")
    @SysCode(sys = "yst-after-sale", mod = "COMPLAINT_TYPE")
    private String orderType;
    private String orderTypeName;

    @ApiModelProperty("来源")
    @ExcelProperty("来源")
    private String source;

    @ApiModelProperty("联系人")
    @ExcelProperty("客户名称")
    private String orderPerson;

    @ApiModelProperty("所属经销商名称")
    @ExcelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("反馈人")
    @ExcelProperty("反馈人")
    private String feedbackPerson;

    @ApiModelProperty("联系电话")
    @ExcelProperty("联系电话")
    private String orderTel;

    @ApiModelProperty("问题类型id")
    private String issueType;
    @ExcelProperty("问题分类")
    private String issueTypeName;

    @ApiModelProperty("车型")
    @ExcelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("车架号")
    @ExcelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;

    @CreatedDate
    @ExcelProperty("提交时间")
    private LocalDateTime createTime;

    @ApiModelProperty("问题描述")
    @ExcelProperty("问题描述")
    private String issueDescription;

    @ApiModelProperty("备注")
    @ExcelProperty("备注")
    private String remark;

    @ApiModelProperty("确认分类")
    private String confirmType;
    @ExcelProperty("确认问题分类")
    private String confirmTypeName;

    @ApiModelProperty("处理状态")
    @SysCode(sys = "yst-after-sale", mod = "COMPLAINT_ORDER")
    private String orderStatus;
    @ExcelProperty("处理结果")
    private String orderStatusName;


    @ApiModelProperty("时效状态")
    @SysCode(sys = "yst-after-sale", mod = "TIMEOUT_STATUS")
    private String timeoutStatus;
    private String timeoutStatusName;

    @ApiModelProperty("车主id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carOwnerId;

    @LastModifiedDate
    private LocalDateTime modifyTime;

    @ApiModelProperty("处理人姓名")
    private String handlePersonName;

    @ApiModelProperty("处理人电话")
    private String handlePersonTel;

    @ApiModelProperty("处理回复")
    private String handleReply;

    @ApiModelProperty("最新回复")
    private String latestReply;

    @ApiModelProperty("C端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_C")
    private String cancelReasonC;
    private String cancelReasonCName;

    @ApiModelProperty("B端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_B")
    private String cancelReasonB;
    private String cancelReasonBName;

    @ApiModelProperty("取消原因明细")
    private String cancelDetail;

    @ApiModelProperty("基地")
    private String baseNo;

    @ApiModelProperty("问题补充")
    private String issueSupplement;

    @ApiModelProperty("细分分类")
    private String subdivisionType;

    @ApiModelProperty("派单人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long dispatchPersonId;

    @ApiModelProperty("派单时间")
    private LocalDateTime dispatchTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("评论信息")
    OrderEvaluationVO orderEvaluationVO;

    @ApiModelProperty("图片信息")
    List<PictureOrderVO> pictureOrderVOS;

    @ApiModelProperty("完成图片")
    List<PictureOrderVO> completePictureVOS;

    @ApiModelProperty("日志")
    List<OrderLogVO> orderLogs;

    @ApiModelProperty("最新回复")
    List<OrderLogVO> replies;

    @ApiModelProperty("评价状态")
    @ExcelProperty("评价状态")
    String evaluationStatus;

    @ApiModelProperty("评价内容")
    @ExcelProperty("评价内容")
    private String evaluationContent;

    @ApiModelProperty("评价级别(1：满意，2：不满意)")
    @SysCode(sys = "yst-after-sale", mod = "EVALUATION_LEVEL")
    private String evaluationLevel;
    @ExcelProperty("评级")
    private String evaluationLevelName;

    @ApiModelProperty("评价时间")
    @ExcelProperty("评价时间")
    private LocalDateTime evaluationTime;

    @ApiModelProperty("回访满意度")
    @SysCode(sys = "yst-after-sale", mod = "RETURN_LEVEL")
    private String returnLevel;
    @ExcelProperty("回访满意度")
    private String returnLevelName;

    @ApiModelProperty("改善意见")
    @ExcelProperty("改善意见")
    private String returnAdvice;

    @ApiModelProperty("生产日期")
    LocalDateTime manufactureDate;

    @ApiModelProperty("出库日期")
    LocalDateTime docTime;

    @ApiModelProperty("激活绑定日期")
    LocalDateTime bindActiveTime;

    @ApiModelProperty("绑定时间")
    private LocalDateTime bindingTime;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("激活时间")
    private LocalDateTime activatTime;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof PictureOrderVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
