package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


@EqualsAndHashCode(callSuper = true)
@Data
public class PictureOrderVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("地址信息")
    String url;

    @ApiModelProperty("完整地址信息")
    String fullUrl;

    @ApiModelProperty("编码")
    String code;

    @ApiModelProperty("维修工单id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long orderId;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-after-sale", mod = "PICTURE_ORDER_TYPE")
    String orderType;
    String orderTypeName;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof PictureOrderVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
