package com.elitesland.yst.production.aftersale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.bo.CarOwnerBasicBO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.param.RegisterMemberParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * @author Danny.Wang
 * @title CarOwnerInfoService
 * @Date2023/2/8 13:27
 */
public interface CarOwnerInfoService {

    /**
     * 车主信息保存更新
     * @param carOwnerInfoParam
     * @return
     */
    ApiResult<Object> save(CarOwnerInfoParam carOwnerInfoParam);

    /**
     * 车主信息查询
     * @param
     * @return
     */
    ApiResult<Object> query();

    /**
     * 个人中心主页信息查询
     * @return
     */
    ApiResult<Object> pageInfoQuery();

    /**
     * 注册车主
     * <p>
     * 根据casUserId查询车主ID，如果查到，则直接返回，否则先注册车主，然后再返回车主的ID
     *
     * @param phone     车主手机号
     * @param casUserId 统一认证中心的用户ID
     * @return 车主ID
     */
    ApiResult<Long> registerCarOwnerOnNotExists(@NotBlank String phone, @NotNull Long casUserId,String userName);

    /**
     * 根据车主ID获取车主基本信息
     * <p>
     * 主要用于登录时获取基本信息
     *
     * @param carOwnerId 车主ID
     * @return 车主信息
     */
    ApiResult<CarOwnerBasicBO> getCarOwnerByCarOwnerId(@NotNull Long carOwnerId);

    /**
     * 车主信息管理 - 分页查询
     * @param param
     * @return
     */
    PagingVO<CarOwnerInfoMngRespVO> ownerInfoMngQuery(CarOwnerInfoMngParam param);

    /**
     * 车主信息管理 - 启用/禁用
     * @param casUserIds
     * @param enabled
     * @param enabledFlag
     */
    void ownerInfoMngUpdateStatus(List<Long> casUserIds, boolean enabled, int enabledFlag);

    /**
     * 车主信息管理 - 明细查询
     * @param carOwnerId
     * @return
     */
    CarOwnerInfoMngRespVO ownerInfoMngDetail(Long carOwnerId);

    /**
     * 经销商pc端车主信息 - 通过手机号查询车主信息
     * @param userPhone
     * @return
     */
    CarOwnerInfoMngRespVO ownerInfoByUserPhone(String userPhone);

    /**
     * 经销商pc端 - 注册会员
     * @param registerMemberParam
     * @return
     */
    Long registerMember(RegisterMemberParam registerMemberParam);

    /**
     * 售后小程序 - 注销会员
     * @param registerMemberParam
     * @return
     */
    Long cancelMember(RegisterMemberParam registerMemberParam);

    void getKaptcha(String phone);
}
