package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/18
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class VehicleBindInfoExportSaleManServiceImpl implements DataExport<BindSoldVehicleVO, BindSoldVehicleParam> {
    private final CarOwnerVehicleService carOwnerVehicleService;

    @Override
    public String getTmplCode() {
        return "vehicle_bind_export_saleman";
    }

    @Override
    public PagingVO<BindSoldVehicleVO> execute(BindSoldVehicleParam param, int page, int pageSize) {
        param.setSize(800);
        return carOwnerVehicleService.vehicleBindInfoQuerySaleMan(param);
    }

    @Override
    public String exportFileName() {
        return "车辆绑定信息管理导出数据(业务)";
    }


}
