package com.elitesland.yst.production.aftersale.service.repo;

import com.elitesland.yst.production.aftersale.dto.ActivateInfoVO;
import com.elitesland.yst.production.aftersale.dto.LmSaleLinkDTO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import feign.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public interface CarMaintainCardRepo extends JpaRepository<CarMaintainCardDO,Long>, QuerydslPredicateExecutor<CarMaintainCardDO> {
    CarMaintainCardDO findByVehicleNo(String VehicleNo);
    
    @Query(value = "select * from  car_maintain_card  where vehicle_no = ?1 and delete_flag = ?2",nativeQuery = true)
    CarMaintainCardDO findByVehicleNoAndDeleteFlag(String vehicleNo, int deleteFlag);

    @Query(value = "select * from  car_maintain_card  where vehicle_type like :vehicleType% and delete_flag = 0",nativeQuery = true)
    List<CarMaintainCardDO> queryVehicleTypeByItemType5(@Param("vehicleType") String vehicleType);

    List<CarMaintainCardDO> findByCarOwnerId(Long carOwnerId, Pageable pageable);
    
    List<CarMaintainCardDO> findByCarOwnerIdAndDeleteFlag(Long carOwnerId, Pageable pageable, int deleteFlag);

    int countByVehicleNo(String VehicleNo);
    
    int countByVehicleNoAndDeleteFlag(String vehicleNo, int deleteFlag);
    
    int countByCarOwnerId(Long carOwnerId);

    @Query(value ="select count(*) from  car_maintain_card  where cust_code2 = ?1",nativeQuery = true)
    Long findByCustCode2(String custCode2);

    @Query(value = "update car_maintain_card set delete_flag = 1,modify_time = ?2 where id = ?1",nativeQuery = true)
    @Modifying
    void delMaintainCard(Long id,LocalDateTime now);
    @Query(value = "select * from  car_maintain_card  where create_time >= ?1 and  create_time <= ?2 and delete_flag = 0 ",nativeQuery = true)
    List<CarMaintainCardDO> findByCreateTimeBetween(LocalDateTime startTime, LocalDateTime endTime);
    @Query(value = "select * from  car_maintain_card  where modify_time >= ?1 and  modify_time <= ?2 and delete_flag = 1 ",nativeQuery = true)
    List<CarMaintainCardDO> findByModifyTimeBetween(LocalDateTime startTime, LocalDateTime endTime);
}
