package com.elitesland.yst.production.aftersale.service.repo;


import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleRelateDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleRelateRepo
 * @Date2023/2/8 15:30
 */
@Repository
public interface CarOwnerVehicleRelateRepo extends JpaRepository<CarOwnerVehicleRelateDO, Long>, QuerydslPredicateExecutor<CarOwnerVehicleRelateDO> {

    List<CarOwnerVehicleRelateDO> findByCarOwnerId(Long carOwnerId);

    CarOwnerVehicleRelateDO findByCarOwnerIdAndVehicleInfoId(Long carOwnerId, Long vehicleInfoId);

    List<CarOwnerVehicleRelateDO> findByVehicleInfoId(Long vehicleInfoId);

}
