package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.QCarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.QMaintainCardInfoDO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author wang.xl
 * @version V1.0
 * 三包内容信息
 * @package com.elitesland.yst.production.aftersale.service.repo
 * @date 2023/7/7 15:14
 */
@Repository
public class MaintainCardInfoRepoProc {

    private static final QMaintainCardInfoDO qMaintainCardInfoDO = QMaintainCardInfoDO.maintainCardInfoDO;


    @Autowired
    protected JPAQueryFactory jpaQueryFactory;


//    public void delMaintainCard(Long threePackID) {
//
//        jpaQueryFactory.delete(qMaintainCardInfoDO)
//                .where(qMaintainCardInfoDO.vehicleThreePackNo.eq(threePackID))
//                .execute();
//
//    }


    public void delMaintainCard(Long threePackID) {

        jpaQueryFactory.update(qMaintainCardInfoDO)
                .set(qMaintainCardInfoDO.deleteFlag, 1)
                .where(qMaintainCardInfoDO.vehicleThreePackNo.eq(threePackID))
                .execute();

    }


}
