/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.aftersale.convert.OrderLogConvert;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.service.OrderLogService;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepo;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepoProc;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderLogServiceImpl
implements OrderLogService {
    private static final Logger log = LogManager.getLogger(OrderLogServiceImpl.class);
    @Autowired
    private OrderLogRepoProc orderLogRepoProc;
    @Autowired
    private OrderLogRepo orderLogRepo;

    @Override
    public List<OrderLogVO> query(OrderLogPageParam param) {
        if (param.getOrderId() == null || param.getOrderId() == 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5de5\u5355id\u4e3a\u7a7a");
        }
        List<OrderLogVO> query = this.orderLogRepoProc.query(param);
        query.stream().forEach(t -> {
            if (StringUtils.isNotEmpty((CharSequence)t.getOrderType()) && "1".equals(t.getOrderType())) {
                t.setOrderTypeName("\u7ef4\u4fee\u5de5\u5355");
            }
            if (StringUtils.isNotEmpty((CharSequence)t.getOrderType()) && "2".equals(t.getOrderType())) {
                t.setOrderTypeName("\u5ba2\u8bc9\u5de5\u5355");
            }
        });
        return query;
    }

    @Override
    public Long orderLogSave(OrderLogSaveParam saveParam) {
        OrderLogDO orderLogDO = OrderLogConvert.INSTANCE.saveVoTODO(saveParam);
        return ((OrderLogDO)((Object)this.orderLogRepo.save((Object)orderLogDO))).getId();
    }

    @Override
    public void batchSave(List<OrderLogDO> orderLogDOS) {
        this.orderLogRepo.saveAll(orderLogDOS);
    }
}

