/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.util.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.elitesland.yst.production.aftersale.util.excel.support.DataReadListener;
import com.elitesland.yst.production.aftersale.util.excel.support.ImportDataModel;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtil.class);
    private final ExcelReaderBuilder excelReaderBuilder;
    private DataReadListener readListener;

    private ExcelImportUtil(InputStream inputStream) {
        this.excelReaderBuilder = ((ExcelReaderBuilder)EasyExcelFactory.read((InputStream)inputStream).autoCloseStream(Boolean.valueOf(true)).autoTrim(Boolean.valueOf(true))).ignoreEmptyRow(Boolean.valueOf(true));
    }

    public static ExcelImportUtil instance(InputStream inputStream) {
        return new ExcelImportUtil(inputStream);
    }

    public ExcelImportUtil headRow(Integer headRow) {
        this.excelReaderBuilder.headRowNumber(headRow);
        return this;
    }

    public ExcelImportUtil dataType(Class<?> dataType, List<String> dataTypeAttr) {
        this.readListener = new DataReadListener(dataTypeAttr);
        this.readListener.setDataType(dataType);
        return this;
    }

    public ExcelImportUtil dataType(Class<?> dataType, Integer dataTypeAttr) {
        this.readListener = new DataReadListener(dataTypeAttr);
        this.readListener.setDataType(dataType);
        return this;
    }

    public List<Object> readAllSync() throws ExecutionException, InterruptedException {
        if (this.readListener == null) {
            return this.excelReaderBuilder.doReadAllSync();
        }
        this.excelReaderBuilder.registerReadListener((ReadListener)this.readListener);
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> {
            this.excelReaderBuilder.doReadAll();
            return this.readListener.isFinish();
        });
        if (completableFuture.get().booleanValue()) {
            return this.readListener.getDataList();
        }
        return Collections.emptyList();
    }

    public void readAllAsync(Consumer<ImportDataModel> dataConsumer) throws Exception {
        this.readAllAsync(dataConsumer, null);
    }

    public void readAllAsync(Consumer<ImportDataModel> dataConsumer, Integer batchSize) {
        if (this.readListener == null) {
            this.readListener = new DataReadListener();
        }
        this.readListener.setDataSize(batchSize);
        this.readListener.setDataConsumer(dataConsumer);
        this.excelReaderBuilder.registerReadListener((ReadListener)this.readListener);
        this.excelReaderBuilder.doReadAll();
    }
}

