/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.model.bo.CarOwnerBasicBO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDetailManagerCarOwner
extends AbstractUserDetailManager {
    private static final Logger log = LogManager.getLogger(UserDetailManagerCarOwner.class);
    private final CarOwnerInfoService carOwnerInfoService;

    public UserDetailManagerCarOwner(AuthorizationProperties authorizationProperties, CarOwnerInfoService carOwnerInfoService) {
        super((com.elitescloud.boot.auth.client.config.AuthorizationProperties)authorizationProperties);
        this.carOwnerInfoService = carOwnerInfoService;
    }

    public GeneralUserDetails loadUserByUsername(@NotBlank String username) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    public GeneralUserDetails loadUserByMobile(@NotBlank String mobile) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    public GeneralUserDetails loadUserByEmail(@NotBlank String email) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    public GeneralUserDetails loadUserById(@NotBlank String userId) {
        return this.loadUser(() -> (CarOwnerBasicBO)this.carOwnerInfoService.getCarOwnerByCarOwnerId(Long.valueOf(userId)).getData());
    }

    public GeneralUserDetails loadUserByAccount(@NotBlank String account) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    public GeneralUserDetails loadUserByWechatOpenid(@NotBlank String wechatOpenid) {
        throw new AuthorizationException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
    }

    private GeneralUserDetails loadUser(Supplier<CarOwnerBasicBO> userDTOSupplier) {
        CarOwnerBasicBO owner = userDTOSupplier.get();
        if (owner == null) {
            return null;
        }
        SysUserDTO userDTO = new SysUserDTO();
        userDTO.setId(owner.getCarOwnerId());
        userDTO.setUsername(CharSequenceUtil.blankToDefault((CharSequence)owner.getUserName(), (String)""));
        userDTO.setMobile(owner.getUserPhone());
        userDTO.setLastName(userDTO.getUsername());
        userDTO.setEnabled(Boolean.valueOf(true));
        userDTO.setSysTenantVO(owner.getTenantDTO());
        ArrayList<SysTenantDTO> tenantList = new ArrayList<SysTenantDTO>(4);
        if (owner.getTenantDTO() != null) {
            tenantList.add(owner.getTenantDTO());
        }
        userDTO.setSysTenantDTOList(tenantList);
        return super.wrapUserDetails(userDTO);
    }
}

