/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.out.sale;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.rpc.LmCustRpcService;
import com.elitesland.yst.production.sale.rpc.param.SalesmanStoreDTO;
import com.elitesland.yst.production.sale.service.CrmCustRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrmSaleServiceImpl
implements CrmSaleService {
    private static final Logger log = LoggerFactory.getLogger(CrmSaleServiceImpl.class);
    private final LmCustRpcService lmCustRpcService;
    private final CrmCustRpcService crmCustRpcService;

    @Override
    public CrmCustSimpleVO getCustSimple(Long userId) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)userId));
        try {
            CrmCustSimpleVO custSimple = this.lmCustRpcService.getCustSimpleByUserId(userId);
            log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)custSimple));
            return custSimple;
        }
        catch (Exception e) {
            log.error("getCustSimple error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    @Override
    public CrmCustSimpleVO bcGetCustSimple(String userName) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)userName));
        try {
            CrmCustSimpleVO custSimple = this.crmCustRpcService.getCustSimple(userName);
            log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)custSimple));
            return custSimple;
        }
        catch (Exception e) {
            log.error("getCustSimple error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    @Override
    public List<CrmCustRespDTO> getCustByParam(CrmCustRpcDtoParam crmCustRpcDtoParam) {
        log.info("getCustByParam\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)crmCustRpcDtoParam));
        try {
            ApiResult custByParam = this.crmCustRpcService.getCustByParam(crmCustRpcDtoParam);
            log.info("getCustByParam\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)custByParam.getData()));
            return (List)custByParam.getData();
        }
        catch (Exception e) {
            log.error("getCustByParam error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "getCustByParam\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    @Override
    public List<CustCode2BaseDTO> getCustByCustCode2(CustCode2BaseParam custCode2BaseParam) {
        log.info("getCustByCustCode2\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)custCode2BaseParam));
        try {
            ApiResult custByParam = this.crmCustRpcService.getByCust2Base(custCode2BaseParam);
            log.info("getCustByCustCode2\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)custByParam.getData()));
            return (List)custByParam.getData();
        }
        catch (Exception e) {
            log.error("getCustByCustCode2 error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "getCustByCustCode2\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    @Override
    public ApiResult<List<SalesmanLevelInfoDTO>> queryLevelInfos(List<Long> ids) {
        log.info("queryLevelInfo\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString(ids));
        try {
            ApiResult listApiResult = this.crmCustRpcService.queryLevelInfos(ids);
            log.info("queryLevelInfo\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)listApiResult));
            return listApiResult;
        }
        catch (Exception e) {
            log.error("queryLevelInfo error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "queryLevelInfo\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    @Override
    public List<Long> querySaleManStoreIds(String empCode) {
        log.info("querySaleManStoreIds\u67e5\u8be2\u4e1a\u52a1\u5458\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1a{}" + empCode);
        try {
            List saleManStoreList = this.lmCustRpcService.querySalesmanStore(empCode);
            log.info("queryLevelInfo\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}" + JSON.toJSONString((Object)saleManStoreList));
            saleManStoreList = saleManStoreList.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getId())).collect(Collectors.toList());
            ArrayList<Long> idList = new ArrayList<Long>();
            for (SalesmanStoreDTO x2 : saleManStoreList) {
                idList.addAll(x2.getId());
            }
            return idList;
        }
        catch (Exception e) {
            log.error("querySaleManStoreIds error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "querySaleManStoreIds\u67e5\u8be2\u4e1a\u52a1\u5458\u95e8\u5e97\u4fe1\u606f\u5165\u53c2" + e.getMessage());
        }
    }

    public CrmSaleServiceImpl(LmCustRpcService lmCustRpcService, CrmCustRpcService crmCustRpcService) {
        this.lmCustRpcService = lmCustRpcService;
        this.crmCustRpcService = crmCustRpcService;
    }
}

