/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.provider.sale;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.order.rpc.LmSaleDoRpcService;
import com.elitesland.yst.production.order.rpc.param.resp.VehicleNoInfoVO;
import com.elitesland.yst.production.sale.rpc.VinOrderRpcService;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.query.ProdOrderVehicleRpcParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VinOrderRpcProvider {
    private static final Logger log = LogManager.getLogger(VinOrderRpcProvider.class);
    @Autowired
    private VinOrderRpcService vinOrderRpcService;
    @Autowired
    private LmSaleDoRpcService lmSaleDoRpcService;

    public VinOrderRpcDTO getByVinNo(String vinNo) {
        VinOrderRpcDTO vinOrderRpcDTO = null;
        try {
            VehicleNoInfoVO vehicleNoInfoVO = this.lmSaleDoRpcService.queryVehicleNoInfo(vinNo);
            if (null != vehicleNoInfoVO) {
                vinOrderRpcDTO = new VinOrderRpcDTO();
                vinOrderRpcDTO.setVinNo(vehicleNoInfoVO.getVehicleNo());
                vinOrderRpcDTO.setMtnrv(vehicleNoInfoVO.getItemCode());
                vinOrderRpcDTO.setId(vehicleNoInfoVO.getItemId());
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528order\u5931\u8d25:" + e.getMessage());
        }
        if (null == vinOrderRpcDTO) {
            try {
                vinOrderRpcDTO = this.vinOrderRpcService.getByVinNo(vinNo);
            }
            catch (Exception e) {
                throw new BusinessException("\u8c03\u7528sale\u5931\u8d25:" + e.getMessage());
            }
        }
        if (null == vinOrderRpcDTO) {
            throw new BusinessException("\u8f66\u67b6\u53f7\u672a\u5173\u8054\u5230\u5546\u54c1\u4fe1\u606f\uff1a" + vinNo + ",\u8bf7\u8054\u7cfb\u4e1a\u52a1\u4e3b\u7ba1");
        }
        if (StringUtils.isEmpty((CharSequence)vinOrderRpcDTO.getMtnrv())) {
            throw new BusinessException("\u8f66\u67b6\u53f7\u5173\u8054\u5546\u54c1\u4fe1\u606f,\u5e93\u5b58\u7269\u6599(\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
        }
        return vinOrderRpcDTO;
    }

    public List<VinOrderRpcDTO> getByVinNos(List<String> vinNo) {
        ProdOrderVehicleRpcParam param = new ProdOrderVehicleRpcParam();
        param.setVinNoList(vinNo);
        List vinOrderRpcDTO = null;
        try {
            vinOrderRpcDTO = this.vinOrderRpcService.queryVehicles(param);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528sale\u5931\u8d25:" + e.getMessage());
        }
        return vinOrderRpcDTO;
    }
}

