package com.elitesland.yst.production.aftersale.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecClsDO;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecClsRespVO;
import com.elitesland.yst.production.aftersale.model.vo.save.PhoneRecClsSaveVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Mapper(config = BaseMapperConfig.class)
public interface PhoneRecClsConvert {

    PhoneRecClsConvert INSTANCE = Mappers.getMapper(PhoneRecClsConvert.class);

    PhoneRecClsDO saveVOToDO(PhoneRecClsSaveVO param);

    @Mappings({
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "code", ignore = true)

    })
    void updatePhoneRecClsDO(PhoneRecClsSaveVO param, @MappingTarget PhoneRecClsDO phoneRecClsDO);

    PhoneRecClsRespVO phoneRecClsDOToRespVO(PhoneRecClsDO phoneRecClsDO);

    List<PhoneRecClsRespVO> phoneRecClsDOToRespVOs(List<PhoneRecClsDO> phoneRecClsDO);


}
